/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.TemplateUtils;
import com.fr.base.Utils;
import com.fr.form.ui.Widget;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.parser.Ambiguity;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.script.AbstractNameSpace;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ColumnRowRange;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.SessionIDInfor;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public abstract class FieldEditor
extends Widget {
    protected boolean allowBlank = true;
    protected String errorMessage;
    protected int fontSize = DEFAULT_FONT_SIZE;

    public boolean isAllowBlank() {
        return this.allowBlank;
    }

    public void setAllowBlank(boolean bl) {
        this.allowBlank = bl;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
    }

    public String getErrorMessage() {
        return this.errorMessage == null ? "" : this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public boolean isEditor() {
        return true;
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public String[] supportedEvents() {
        return new String[]{"afterinit", "beforeedit", "afteredit", "stopedit"};
    }

    public JSONArray createJSONData(SessionIDInfor sessionIDInfor, Calculator calculator, HttpServletRequest httpServletRequest) throws Exception {
        return new JSONArray();
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        if (StringUtils.isNotBlank(this.errorMessage)) {
            jSONObject.put("errorMsg", this.errorMessage);
        }
        if (!this.allowBlank) {
            jSONObject.put("allowBlank", this.allowBlank);
        }
        jSONObject.put("fontSize", this.fontSize);
        return jSONObject;
    }

    public static void setWaterMarkConfig(String string, JSONObject jSONObject, Calculator calculator) throws JSONException {
        try {
            if (string != null && string.startsWith("=")) {
                string = Utils.objectToString(calculator.eval(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        jSONObject.put("watermark", string);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            if (xMLableReader.getTagName().equals("FieldName")) {
                this.setWidgetName(xMLableReader.getElementValue());
            }
            if (xMLableReader.getTagName().equals("EMSG")) {
                this.errorMessage = xMLableReader.getElementValue();
            }
            if (xMLableReader.getTagName().equals("allowBlank")) {
                this.allowBlank = false;
            }
            if (ComparatorUtils.equals(xMLableReader.getTagName(), "fontSize")) {
                this.fontSize = Integer.parseInt(xMLableReader.getElementValue());
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (StringUtils.isNotBlank(this.errorMessage)) {
            xMLPrintWriter.startTAG("EMSG").textNode(this.errorMessage).end();
        }
        if (!this.allowBlank) {
            xMLPrintWriter.startTAG("allowBlank").textNode(String.valueOf(this.allowBlank)).end();
        }
        if (this.fontSize != DEFAULT_FONT_SIZE) {
            xMLPrintWriter.startTAG("fontSize").textNode(this.fontSize + "").end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof FieldEditor && super.equals(object) && ComparatorUtils.equals(this.errorMessage, ((FieldEditor)object).errorMessage) && this.allowBlank == ((FieldEditor)object).allowBlank;
    }

    public static String toJSONString(Object object) throws Exception {
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Date) {
            return JSONObject.date2String((Date)object);
        }
        return TemplateUtils.render(Utils.objectToString(object));
    }

    public static class DependenceNameSpace
    extends AbstractNameSpace {
        private JSONObject depJson;

        public DependenceNameSpace(String string) {
            if (StringUtils.isNotBlank(string)) {
                try {
                    Object object = BaseUtils.jsonDecode(string);
                    if (object instanceof JSONObject) {
                        this.depJson = (JSONObject)object;
                        this.dealArray();
                    }
                }
                catch (JSONException jSONException) {
                    FRContext.getLogger().error(jSONException.getMessage(), jSONException);
                }
            }
        }

        private void dealArray() throws JSONException {
            Iterator iterator = this.depJson.keys();
            while (iterator.hasNext()) {
                String string = Utils.objectToString(iterator.next());
                Object object = this.depJson.get(string);
                if (!(object instanceof JSONArray)) continue;
                FArray<Object> fArray = new FArray<Object>();
                JSONArray jSONArray = (JSONArray)object;
                for (int i = 0; i < jSONArray.length(); ++i) {
                    fArray.simpleAdd(jSONArray.get(i));
                }
                this.depJson.put(string, fArray);
            }
        }

        public Object getVariable(Object object, CalculatorProvider calculatorProvider) {
            if (this.depJson != null) {
                String string;
                if (this.depJson.length() == 0) {
                    return null;
                }
                if ((object instanceof ColumnRowRange || object instanceof Ambiguity || object instanceof String) && (this.depJson.has(string = object.toString().toUpperCase()) || this.depJson.has("$" + string))) {
                    try {
                        return this.depJson.get(string);
                    }
                    catch (JSONException jSONException) {
                        try {
                            return this.depJson.get("$" + string);
                        }
                        catch (JSONException jSONException2) {
                            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
                        }
                    }
                }
            }
            return null;
        }
    }
}

