/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.TableData;
import com.fr.data.AbstractDataModel;
import com.fr.data.AbstractParameterTableData;
import com.fr.data.impl.storeproc.MemCachedProcedureDataModel;
import com.fr.data.impl.storeproc.ProcedureDataModel;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.DefaultValues;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.script.Calculator;
import com.fr.stable.CodeUtils;
import com.fr.stable.Mapper;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Image;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedTableData
extends AbstractParameterTableData
implements XMLable {
    private static final String BINARYOBJECT = "binary object cannot be previewed";
    private List columnNameList = new ArrayList();
    private List columnClassList = new ArrayList();
    private List rowData = new ArrayList();
    private String dsName = "";
    private static final long serialVersionUID = 2974039836068979294L;
    private transient DataModel dataModel = null;
    Pattern nSplitPattern = Pattern.compile("\\Q\n\\E");
    Pattern tSplitPattern = Pattern.compile("\\Q\t\\E");
    Pattern tPattern = Pattern.compile("\\Q&t;\\E");
    Pattern nPattern = Pattern.compile("\\Q&n;\\E");
    private static final Mapper CLASS2NAME = new Mapper(){

        public Object map(int n, Object object, List list) {
            return object instanceof Class ? ((Class)object).getName() : null;
        }
    };

    public void addColumn(String string, Class clazz) {
        this.columnNameList.add(string);
        this.columnClassList.add(clazz);
        for (int i = 0; i < this.rowData.size(); ++i) {
            List list = (List)this.rowData.get(i);
            list.add(this.getDefaultValueOfClass(clazz));
        }
    }

    public List getRowData() {
        return this.rowData;
    }

    public void insertColumn(String string, Class clazz, int n) {
        this.columnNameList.add(n + 1, string);
        this.columnClassList.add(n + 1, clazz);
        for (int i = 0; i < this.rowData.size(); ++i) {
            List list = (List)this.rowData.get(i);
            list.add(n + 1, this.getDefaultValueOfClass(clazz));
        }
    }

    public void setColumn(int n, String string, Class clazz) {
        if (n < 0 || n >= this.columnNameList.size()) {
            return;
        }
        this.columnNameList.set(n, string);
        this.columnClassList.set(n, clazz);
        for (int i = 0; i < this.rowData.size(); ++i) {
            List list = (List)this.rowData.get(i);
            Object e = list.get(n);
            if (e == null) continue;
            list.set(n, this.getValueOfClass(e, clazz));
        }
    }

    public void removeColumn(int n) {
        if (n < 0 || n >= this.columnNameList.size()) {
            return;
        }
        this.columnNameList.remove(n);
        this.columnClassList.remove(n);
        int n2 = this.rowData.size();
        for (int i = 0; i < n2; ++i) {
            List list = (List)this.rowData.get(i);
            list.remove(n);
        }
    }

    public void addRow(List list) {
        this.addRow(this.getRowCount(), list);
    }

    public void addRow(int n, List list) {
        int n2 = this.getColumnCount();
        if (list.size() < n2) {
            for (int i = list.size(); i < n2; ++i) {
                list.add(this.getDefaultValueOfClass(this.getColumnClass(i)));
            }
        }
        if (n >= this.rowData.size()) {
            this.rowData.add(list);
        } else {
            this.rowData.add(n, list);
        }
    }

    public void addRow(int n, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        this.addRow(n, arrayList);
    }

    public void addNewRow(int n) {
        int n2 = this.getColumnCount();
        if (n2 <= 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(this.getDefaultValueOfClass(this.getColumnClass(i)));
        }
        this.addRow(n, arrayList);
    }

    public void removeRow(int n) {
        if (n < 0 || n >= this.rowData.size()) {
            return;
        }
        this.rowData.remove(n);
    }

    public int getColumnCount() {
        return this.columnNameList.size();
    }

    public ProcedureDataModel trans2ProcedureDataModel() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < this.rowData.size(); ++i) {
            List list = (List)this.rowData.get(i);
            Object[] objectArray = new Object[list.size()];
            arrayList.add(objectArray);
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                objectArray[j] = list.get(j);
            }
        }
        String[] stringArray = new String[this.columnNameList.size()];
        for (int i = 0; i < this.columnNameList.size(); ++i) {
            stringArray[i] = (String)this.columnNameList.get(i);
        }
        return new MemCachedProcedureDataModel(arrayList, stringArray, this.dsName);
    }

    public String getColumnName(int n) {
        return (String)this.columnNameList.get(n);
    }

    public Class getColumnClass(int n) {
        if (n >= 0 && n < this.columnClassList.size()) {
            return (Class)this.columnClassList.get(n);
        }
        return String.class;
    }

    public int getRowCount() {
        return this.rowData.size();
    }

    public Object getValueAt(int n, int n2) {
        List list = (List)this.rowData.get(n);
        if (n2 < 0 || n2 >= list.size()) {
            return null;
        }
        Object e = list.get(n2);
        if (e == null) {
            return Primitive.NULL;
        }
        return e;
    }

    public Object getValueOfClass(Object object, Class clazz) {
        if (object == null) {
            return Primitive.NULL;
        }
        if (object.getClass() == clazz) {
            return object;
        }
        String string = object.toString();
        try {
            if (clazz == Integer.class) {
                Float f = Float.valueOf(string);
                return new Integer(Math.round(f.floatValue()));
            }
            if (clazz == Double.class || clazz == Float.class) {
                return new Double(string);
            }
            if (clazz == java.util.Date.class) {
                return new java.util.Date(Long.parseLong(string));
            }
            if (clazz == Boolean.class) {
                return Boolean.valueOf(string);
            }
            if (clazz == Image.class) {
                return "Image";
            }
            return string;
        }
        catch (Exception exception) {
            return this.getDefaultValueOfClass(clazz);
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        boolean bl;
        boolean bl2 = n2 < 0 || n2 >= this.getColumnCount();
        boolean bl3 = bl = n < 0 || n >= this.getRowCount();
        if (bl2 || bl) {
            return;
        }
        ArrayList<Object> arrayList = (ArrayList<Object>)this.rowData.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        if (arrayList.size() <= n2 || arrayList.get(n2) == null) {
            for (int i = arrayList.size(); i < n2; ++i) {
                arrayList.add(i, "");
            }
            arrayList.add(n2, object);
        } else {
            arrayList.set(n2, object);
        }
    }

    public String toString() {
        return "EmbeddedTableData[ColumnCount:" + this.getColumnCount() + ",RowCount" + this.getRowCount() + "]";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        EmbeddedTableData embeddedTableData = (EmbeddedTableData)super.clone();
        embeddedTableData.columnNameList = arrayList3 = new ArrayList();
        for (int i = 0; i < this.columnNameList.size(); ++i) {
            arrayList3.add(this.columnNameList.get(i));
        }
        embeddedTableData.columnClassList = arrayList2 = new ArrayList();
        for (int i = 0; i < this.columnClassList.size(); ++i) {
            arrayList2.add(this.columnClassList.get(i));
        }
        embeddedTableData.rowData = arrayList = new ArrayList();
        for (int i = 0; i < this.rowData.size(); ++i) {
            ArrayList arrayList4 = new ArrayList();
            arrayList.add(arrayList4);
            List list = (List)this.rowData.get(i);
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                arrayList4.add(list.get(j));
            }
        }
        return embeddedTableData;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isAttr()) {
            this.columnClassList = new ArrayList();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("XMLVersion")) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    xMLableReader.setXmlVersionByString(string2);
                }
            } else if ("DSName".equals(string)) {
                String string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    this.dsName = string3;
                }
            } else if ("ColumnNames".equals(string)) {
                String string4 = xMLableReader.getElementValue();
                if (string4 != null) {
                    this.columnNameList.clear();
                    String[] stringArray = StableUtils.splitString(string4, ",,.,,");
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.columnNameList.add(stringArray[i]);
                    }
                }
            } else if ("ColumnTypes".equals(string)) {
                String string5 = xMLableReader.getElementValue();
                if (string5 != null) {
                    String[] stringArray = StableUtils.splitString(string5, ",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        try {
                            this.columnClassList.add(GeneralUtils.classForName(stringArray[i]));
                            continue;
                        }
                        catch (Exception exception) {
                            this.columnClassList.add(String.class);
                        }
                    }
                }
            } else if ("RowData".equals(string)) {
                this.readRowData(xMLableReader);
            }
        }
    }

    public void readRowData(XMLableReader xMLableReader) {
        String string = null;
        if (xMLableReader.getXMLVersion().isAfterEM_CODE_XML_VERSION()) {
            try {
                string = new String(GeneralXMLTools.readByteArray(xMLableReader), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        } else {
            string = new String(GeneralXMLTools.readByteArray(xMLableReader));
        }
        if (this.columnClassList.size() <= 0 || string == null) {
            return;
        }
        ValueReader[] valueReaderArray = new ValueReader[this.columnClassList.size()];
        for (int i = 0; i < this.columnClassList.size(); ++i) {
            valueReaderArray[i] = ValueReaderFactory.createValueReader((Class)this.columnClassList.get(i));
        }
        this.rowData.clear();
        String[] stringArray = null;
        stringArray = string == null || string.length() == 0 ? new String[]{} : this.nSplitPattern.split(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String[] stringArray2 = null;
            stringArray2 = string2 == null || string2.length() == 0 ? new String[]{} : this.tSplitPattern.split(string2);
            ArrayList arrayList = new ArrayList();
            this.rowData.add(arrayList);
            for (int j = 0; j < stringArray2.length; ++j) {
                String string3 = stringArray2[j];
                if (string3 != null && string3.length() > 0) {
                    string3 = this.tPattern.matcher(string3).replaceAll("\t");
                    string3 = this.nPattern.matcher(string3).replaceAll("\n");
                }
                arrayList.add(valueReaderArray[j].readValue(string3));
            }
        }
    }

    private void readDataDetails(List list, String string, Class clazz) {
        if (ComparatorUtils.equals(Double.class, clazz)) {
            try {
                list.add(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                list.add(new Double(0.0));
            }
        } else if (ComparatorUtils.equals(Integer.class, clazz)) {
            try {
                list.add(Integer.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                list.add(new Integer(0));
            }
        } else if (ComparatorUtils.equals(BigDecimal.class, clazz)) {
            try {
                list.add(new BigDecimal(string));
            }
            catch (NumberFormatException numberFormatException) {
                list.add(string);
            }
        } else if (ComparatorUtils.equals(Boolean.class, clazz)) {
            list.add(Boolean.valueOf(string));
        } else if (ComparatorUtils.equals(Image.class, clazz)) {
            this.readClass(string, list);
        } else if (ComparatorUtils.equals(java.util.Date.class, clazz)) {
            list.add(DateUtils.object2Date(string, false));
        } else {
            list.add(string);
        }
    }

    private static Image readClass(String string) {
        String[] stringArray = StableUtils.splitString(string, ",;,");
        if (stringArray.length == 3) {
            try {
                return GeneralXMLTools.deprecatedDecodeImage(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), stringArray[2].getBytes());
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        } else {
            if (stringArray.length == 1) {
                return GeneralXMLTools.imageDecode(stringArray[2].getBytes());
            }
            FRLogger.getLogger().error("Error to load embbed image object");
        }
        return null;
    }

    private void readClass(String string, List list) {
        String[] stringArray = StableUtils.splitString(string, ",;,");
        if (stringArray.length == 3) {
            try {
                list.add(GeneralXMLTools.deprecatedDecodeImage(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), stringArray[2].getBytes()));
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        } else if (stringArray.length == 1) {
            list.add(GeneralXMLTools.imageDecode(stringArray[2].getBytes()));
        } else {
            FRLogger.getLogger().error("Error to load embbed image object");
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("DSName").textNode(this.dsName).end();
        xMLPrintWriter.startTAG("ColumnNames").textNode(StableUtils.join(this.columnNameList, ",,.,,")).end();
        xMLPrintWriter.startTAG("ColumnTypes").textNode(StableUtils.join(StableUtils.map(this.columnClassList, CLASS2NAME), ",")).end();
        if (this.rowData.size() <= 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.writeAllData(stringBuffer);
        xMLPrintWriter.startTAG("RowData");
        try {
            GeneralXMLTools.writeByteArray(xMLPrintWriter, stringBuffer.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        xMLPrintWriter.end();
    }

    private void writeAllData(StringBuffer stringBuffer) {
        for (int i = 0; i < this.rowData.size(); ++i) {
            if (i != 0) {
                stringBuffer.append('\n');
            }
            List list = (List)this.rowData.get(i);
            for (int j = 0; j < list.size(); ++j) {
                Object object;
                Object e;
                if (j != 0) {
                    stringBuffer.append('\t');
                }
                if ((e = list.get(j)) == null) {
                    stringBuffer.append("");
                    continue;
                }
                Class clazz = (Class)this.columnClassList.get(j);
                if (clazz == Integer.class || clazz == Double.class || clazz == Float.class || clazz == BigDecimal.class || clazz == Boolean.class) {
                    stringBuffer.append(GeneralUtils.objectToString(e));
                    continue;
                }
                if (clazz == java.util.Date.class && e instanceof java.util.Date) {
                    object = GeneralContext.getDefaultValues();
                    stringBuffer.append(((DefaultValues)object).getDateTimeFormat().format(e));
                    continue;
                }
                if (clazz == Image.class) {
                    object = (Image)e;
                    byte[] byArray = GeneralXMLTools.imageEncode((Image)object);
                    stringBuffer.append(byArray);
                    continue;
                }
                if (clazz == Timestamp.class) {
                    this.writeTimeType(e, stringBuffer);
                    continue;
                }
                object = GeneralUtils.objectToString(e);
                object = CodeUtils.encodeString((String)object, new String[][]{{"&t;", "&n;"}, {"\t", "\n"}});
                stringBuffer.append((String)object);
            }
        }
    }

    private void writeTimeType(Object object, StringBuffer stringBuffer) {
        Timestamp timestamp;
        DefaultValues defaultValues = GeneralContext.getDefaultValues();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (object instanceof String) {
            if (StringUtils.isBlank((String)object)) {
                timestamp = null;
            } else if (((String)object).indexOf(":") == -1) {
                Date date = Date.valueOf((String)object);
                String string = simpleDateFormat.format(date);
                timestamp = Timestamp.valueOf(string);
            } else {
                timestamp = Timestamp.valueOf((String)object);
            }
        } else if (object instanceof java.util.Date) {
            String string = simpleDateFormat.format((java.util.Date)object);
            timestamp = Timestamp.valueOf(string);
        } else {
            timestamp = object instanceof Timestamp ? (Timestamp)object : null;
        }
        if (timestamp != null) {
            stringBuffer.append(defaultValues.getDateTimeFormat().format(new java.util.Date(timestamp.getTime())));
        }
    }

    public static EmbeddedTableData embedify(TableData tableData, Calculator calculator) throws TableDataException {
        return EmbeddedTableData.embedify(tableData, calculator, -1);
    }

    public void clear() {
        this.columnClassList.clear();
        this.columnNameList.clear();
        this.rowData.clear();
    }

    public static EmbeddedTableData embedify(TableData tableData, Calculator calculator, int n) throws TableDataException {
        EmbeddedTableData embeddedTableData = new EmbeddedTableData();
        if (tableData != null) {
            int n2;
            DataModel dataModel = EmbeddedTableData.createDataModel(tableData, calculator, n);
            if (!EmbeddedTableData.isValidSQL(dataModel, n)) {
                dataModel = EmbeddedTableData.createDataModel(tableData, calculator, 1);
            }
            int n3 = dataModel.getColumnCount();
            Class[] classArray = new Class[n3];
            String[] stringArray = new String[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray[n2] = dataModel.getColumnName(n2);
            }
            if (n < 0) {
                n = dataModel.getRowCount();
            } else if (n != 0 && !dataModel.hasRow(n - 1)) {
                n = dataModel.getRowCount();
            }
            for (n2 = 0; n2 < n; ++n2) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < n3; ++i) {
                    Object object = dataModel.getValueAt(n2, i);
                    if (classArray[i] == null && object != null) {
                        classArray[i] = object.getClass();
                    }
                    arrayList.add(object);
                }
                embeddedTableData.addRow(arrayList);
            }
            embeddedTableData.columnClassList = new ArrayList();
            embeddedTableData.columnClassList.addAll(Arrays.asList(classArray));
            embeddedTableData.columnNameList = new ArrayList();
            embeddedTableData.columnNameList.addAll(Arrays.asList(stringArray));
            try {
                dataModel.release();
            }
            catch (Exception exception) {
                throw new TableDataException(exception.getMessage(), exception);
            }
        }
        return embeddedTableData;
    }

    public void addColumnNameAndData(String[] stringArray, List list, String string) {
        ArrayList arrayList;
        this.dsName = string;
        this.columnNameList = new ArrayList();
        this.columnNameList.addAll(Arrays.asList(stringArray));
        this.rowData = arrayList = new ArrayList();
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList.add(arrayList2);
            Object[] objectArray = (Object[])list.get(i);
            if (objectArray == null) continue;
            for (int j = 0; j < objectArray.length; ++j) {
                Object object = objectArray[j];
                arrayList2.add(object);
                if (bl) continue;
                this.columnClassList.add(object != null ? objectArray[j].getClass() : String.class);
            }
            bl = true;
        }
    }

    private static DataModel createDataModel(TableData tableData, Calculator calculator, int n) {
        DataModel dataModel = tableData.createDataModel(calculator, n);
        if (dataModel == null) {
            dataModel = DataModel.EMPTY_DATAMODEL;
        }
        return dataModel;
    }

    private static boolean isValidSQL(DataModel dataModel, int n) {
        if (n == 0) {
            try {
                if (dataModel == null) {
                    return false;
                }
                dataModel.getColumnCount();
            }
            catch (TableDataException tableDataException) {
                FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof EmbeddedTableData && ComparatorUtils.equals((Object)this.columnClassList, (Object)((EmbeddedTableData)object).columnClassList) && ComparatorUtils.equals((Object)this.columnNameList, (Object)((EmbeddedTableData)object).columnNameList) && ComparatorUtils.equals((Object)this.rowData, (Object)((EmbeddedTableData)object).rowData);
    }

    @Override
    public DataModel createDataModel(Calculator calculator) {
        if (this.dataModel == null) {
            this.dataModel = new EmbeddedTDDataModel();
        }
        return this.dataModel;
    }

    private Object getDefaultValueOfClass(Class clazz) {
        if (clazz == Integer.class) {
            return new Integer(0);
        }
        if (clazz == Double.class || clazz == Float.class) {
            return new Double(0.0);
        }
        if (clazz == java.util.Date.class) {
            return new java.util.Date();
        }
        if (clazz == Boolean.class) {
            return Boolean.TRUE;
        }
        if (clazz == Image.class) {
            return "Image";
        }
        return "";
    }

    @Override
    public void filterDataType(Class<?> clazz) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            List list = (List)this.rowData.get(i);
            for (int j = 0; j < this.getColumnCount() && list != null; ++j) {
                Object e = list.get(j);
                if (e == null || !e.getClass().equals(clazz)) continue;
                list.set(j, BINARYOBJECT);
            }
        }
    }

    public class EmbeddedTDDataModel
    extends AbstractDataModel {
        public int getColumnCount() throws TableDataException {
            return EmbeddedTableData.this.getColumnCount();
        }

        public Class getColumnClass(int n) {
            return EmbeddedTableData.this.getColumnClass(n);
        }

        public String getColumnName(int n) throws TableDataException {
            return EmbeddedTableData.this.getColumnName(n);
        }

        public int getRowCount() throws TableDataException {
            return EmbeddedTableData.this.getRowCount();
        }

        public Object getValueAt(int n, int n2) throws TableDataException {
            return EmbeddedTableData.this.getValueAt(n, n2);
        }

        public void release() throws Exception {
        }
    }

    private static class ValueReaderFactory {
        private ValueReaderFactory() {
        }

        private static ValueReader createValueReader(Class clazz) {
            if (ComparatorUtils.equals(Double.class, clazz)) {
                return new DoubleReader();
            }
            if (ComparatorUtils.equals(Integer.class, clazz)) {
                return new IntegerReader();
            }
            if (ComparatorUtils.equals(BigDecimal.class, clazz)) {
                return new BigDecimalReader();
            }
            if (ComparatorUtils.equals(Boolean.class, clazz)) {
                return new BooleanReader();
            }
            if (ComparatorUtils.equals(Image.class, clazz)) {
                return new ImageReader();
            }
            if (ComparatorUtils.equals(java.util.Date.class, clazz)) {
                return new DateReader();
            }
            return new StringReader();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringReader
    implements ValueReader<String> {
        private StringReader() {
        }

        @Override
        public String readValue(String string) {
            if (string != null && string.length() == 0) {
                return "";
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateReader
    implements ValueReader<java.util.Date> {
        private DateReader() {
        }

        @Override
        public java.util.Date readValue(String string) {
            return DateUtils.object2Date(string, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImageReader
    implements ValueReader<Image> {
        private ImageReader() {
        }

        @Override
        public Image readValue(String string) {
            return EmbeddedTableData.readClass(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanReader
    implements ValueReader<Boolean> {
        private BooleanReader() {
        }

        @Override
        public Boolean readValue(String string) {
            return Boolean.valueOf(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigDecimalReader
    implements ValueReader<BigDecimal> {
        private BigDecimal DEFAULT_VALUE = new BigDecimal(0);

        private BigDecimalReader() {
        }

        @Override
        public BigDecimal readValue(String string) {
            try {
                return new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                return this.DEFAULT_VALUE;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerReader
    implements ValueReader<Integer> {
        private Integer DEFAULT_VALUE = new Integer(0);

        private IntegerReader() {
        }

        @Override
        public Integer readValue(String string) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return this.DEFAULT_VALUE;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleReader
    implements ValueReader<Double> {
        private Double DEFAULT_VALUE = new Double(0.0);

        private DoubleReader() {
        }

        @Override
        public Double readValue(String string) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return this.DEFAULT_VALUE;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ValueReader<T> {
        public T readValue(String var1);
    }
}

