/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.cache.list.MappedByteBufferTable;
import com.fr.data.impl.AbstractDBDataModel;
import com.fr.data.impl.Connection;
import com.fr.data.impl.TarRowIndexIterateResultSetListener;
import com.fr.general.FRLogger;
import com.fr.general.data.TableDataException;
import java.sql.SQLException;

public final class DiskCacheDBDataModel
extends AbstractDBDataModel {
    private transient MappedByteBufferTable mappedByteBuffer_table = null;
    private DiskCacheIterateResultSetListener iListener = new DiskCacheIterateResultSetListener();

    public DiskCacheDBDataModel(Connection connection, String string) {
        super(connection, string);
    }

    protected void initRowValueStatus() {
        try {
            this.mappedByteBuffer_table = new MappedByteBufferTable(this.getColumnCount());
        }
        catch (TableDataException tableDataException) {
            FRLogger.getLogger().error(tableDataException.getMessage(), tableDataException);
        }
    }

    public synchronized boolean hasRow(int n) throws TableDataException {
        if (this.mappedByteBuffer_table != null && this.mappedByteBuffer_table.columnCount() > 0 && this.mappedByteBuffer_table.rowCount() > n) {
            return true;
        }
        if (this.isCheckRowOver()) {
            return false;
        }
        try {
            this.iListener.setTarRowIndex(n);
            this.iterateResultSet(this.iListener);
        }
        catch (Exception exception) {
            try {
                this.releaseConnection();
            }
            catch (Exception exception2) {
                FRLogger.getLogger().error("Error happens while releaseConnection");
            }
            this.setCheckRowOverState(true);
            throw new TableDataException(exception.getMessage(), exception);
        }
        return this.iListener.cur_rowcount > n;
    }

    public synchronized Object getValueAt(int n, int n2) throws TableDataException {
        return this.hasRow(n) ? this.mappedByteBuffer_table.getValueAt(n2, n) : null;
    }

    public synchronized int getRowCount() throws TableDataException {
        if (this.mappedByteBuffer_table == null || this.mappedByteBuffer_table.rowCount() == 0) {
            this.hasRow(Integer.MAX_VALUE);
        }
        return this.mappedByteBuffer_table.rowCount();
    }

    public synchronized void release() throws SQLException {
        if (this.mappedByteBuffer_table != null) {
            this.mappedByteBuffer_table.clear();
        }
        super.release();
    }

    private class DiskCacheIterateResultSetListener
    extends TarRowIndexIterateResultSetListener {
        private int cur_rowcount;

        private DiskCacheIterateResultSetListener() {
        }

        protected void init() {
            if (DiskCacheDBDataModel.this.mappedByteBuffer_table == null) {
                DiskCacheDBDataModel.this.initRowValueStatus();
            }
            this.cur_rowcount = DiskCacheDBDataModel.this.mappedByteBuffer_table.rowCount();
        }

        protected boolean beforeGetValuesByRowIndex(int n) {
            return true;
        }

        protected void afterGetValueByColumnRowIndex(Object object, int n) throws TableDataException {
            DiskCacheDBDataModel.this.mappedByteBuffer_table.addValueAt(n, object);
        }

        protected void exceptionOnGetValueByColumnRowIndex(int n) {
            DiskCacheDBDataModel.this.mappedByteBuffer_table.addValueAt(n, null);
        }

        protected boolean afterGetValuesByRowIndex() throws TableDataException {
            return ++this.cur_rowcount > this.getTarRowIndex();
        }

        protected void afterIterator() {
        }
    }
}

