/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.AbstractTableData;
import com.fr.base.Parameter;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.DecoratedDataModel;
import com.fr.data.impl.NameTableData;
import com.fr.general.data.Condition;
import com.fr.general.data.DataModel;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Arrays;

public class DecoratedTableData
extends AbstractTableData {
    private String[] relatedTableDataNames;
    private Condition condition;

    public String[] getRelatedTableDataNames() {
        return this.relatedTableDataNames;
    }

    public void setRelatedTableDataNames(String[] stringArray) {
        this.relatedTableDataNames = stringArray;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public DataModel createDataModel(Calculator calculator) {
        DataModel[] dataModelArray = new DataModel[ArrayUtils.getLength(this.relatedTableDataNames)];
        for (int i = 0; i < dataModelArray.length; ++i) {
            dataModelArray[i] = new NameTableData(this.relatedTableDataNames[i]).createDataModel(calculator);
        }
        return new DecoratedDataModel(dataModelArray, this.relatedTableDataNames, this.condition, calculator);
    }

    public DataModel createDataModel(Calculator calculator, String string) {
        return this.createDataModel(calculator);
    }

    public DataModel createDataModel(Calculator calculator, int n) {
        return this.createDataModel(calculator);
    }

    public Parameter[] getParameters(Calculator calculator) {
        ArrayList<ParameterProvider> arrayList = new ArrayList<ParameterProvider>();
        if (this.relatedTableDataNames != null) {
            for (int i = 0; i < this.relatedTableDataNames.length; ++i) {
                arrayList.addAll(Arrays.asList(new NameTableData(this.relatedTableDataNames[i]).getParameters(calculator)));
            }
        }
        if (this.condition != null) {
            String[] stringArray = this.condition.dependence(calculator);
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(new Parameter(stringArray[i]));
            }
        }
        return arrayList.toArray(new Parameter[0]);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n = ArrayUtils.getLength(this.relatedTableDataNames);
        for (int i = 0; i < n; ++i) {
            xMLPrintWriter.startTAG("TDName").textNode(this.relatedTableDataNames[i]).end();
        }
        DataCoreXmlUtils.writeXMLCondition(xMLPrintWriter, this.condition);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("TDName".equals(string2) && StringUtils.isNotBlank(string = xMLableReader.getElementValue())) {
                this.relatedTableDataNames = ArrayUtils.add(this.relatedTableDataNames, string);
            } else if ("Condition".equals(string2)) {
                this.condition = DataCoreXmlUtils.readCondition(xMLableReader);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DecoratedTableData decoratedTableData = (DecoratedTableData)super.clone();
        if (this.relatedTableDataNames != null) {
            decoratedTableData.relatedTableDataNames = ArrayUtils.clone(this.relatedTableDataNames);
        }
        if (this.condition != null) {
            decoratedTableData.condition = (Condition)this.condition.clone();
        }
        return decoratedTableData;
    }
}

