/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.tableObject;

import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.OracleDialect;
import com.fr.data.core.db.dml.AddColumn;
import com.fr.data.core.db.dml.CreateTable;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.core.db.tableObject.TableObject;
import com.fr.data.dao.UniqueKey;
import com.fr.general.FRLogger;
import com.fr.stable.fun.impl.AbstractProvider;
import com.fr.stable.fun.mark.API;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

@API(level=1)
public abstract class AbstractTableObject
extends AbstractProvider
implements TableObject {
    protected List columnsList = new ArrayList();
    protected boolean newTable = false;
    protected List uniqueKeyList = null;
    public static final int CHECK_TABLE_EXSIT_ON_TABLENAME = 0;
    public static final int CHECK_TABLE_EXSIT_ON_TABLECOLUMNNAME = 1;
    protected int checkTableExistLevel = 1;

    public int currentAPILevel() {
        return 1;
    }

    public String mark4Provider() {
        return this.getTable().getName();
    }

    protected abstract void initColumns();

    public AbstractTableObject() {
        this.initColumns();
    }

    public String foreignReference() {
        return null;
    }

    protected Column getColumn(int n) {
        return (Column)this.columnsList.get(n);
    }

    protected void addColumn(Column column) {
        if (column != null) {
            this.columnsList.add(column);
        }
    }

    protected void addColumn(String string, int n, ColumnSize columnSize) {
        this.addColumn(string, n, columnSize, true);
    }

    protected void addColumn(String string, int n, ColumnSize columnSize, boolean bl) {
        this.addColumn(string, n, columnSize, bl, false);
    }

    protected void addColumn(String string, int n, ColumnSize columnSize, boolean bl, boolean bl2) {
        this.addColumn(string, n, columnSize, bl, bl2, false);
    }

    protected void addColumn(String string, int n, ColumnSize columnSize, boolean bl, boolean bl2, boolean bl3) {
        Column column = new Column(string, n, columnSize, null, bl, bl2, bl3);
        this.columnsList.add(column);
    }

    public void addNewColumnCompatibleOld(Connection connection, Dialect dialect) {
    }

    public boolean checkExist(Connection connection) {
        return this.checkTable(connection, this.checkTableExistLevel == 0);
    }

    public boolean checkTable(Connection connection, boolean bl) {
        PreparedStatement preparedStatement;
        Select select = new Select(this.getTable(), DialectFactory.generateDialect(connection)){

            public String toStatementSQLString(Dialect dialect) {
                return this.noResultSQL();
            }
        };
        if (!bl) {
            int n = this.columnsList.size();
            for (int i = 0; i < n; ++i) {
                select.addColumnName(this.getColumn(i).getName());
            }
        }
        try {
            preparedStatement = select.createPreparedStatement(connection);
        }
        catch (SQLException sQLException) {
            return false;
        }
        try {
            preparedStatement.executeQuery();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException2) {
                FRLogger.getLogger().error(sQLException2.getMessage(), sQLException2);
            }
            return false;
        }
        return true;
    }

    public boolean checkSameNameTableExist(Connection connection) {
        return this.checkTable(connection, true);
    }

    public void addUniqueKey(UniqueKey uniqueKey) {
        if (uniqueKey == null) {
            return;
        }
        if (this.uniqueKeyList == null) {
            this.uniqueKeyList = new ArrayList();
        }
        this.uniqueKeyList.add(uniqueKey);
    }

    public void createTable(Connection connection) {
        if (this.checkExist(connection)) {
            return;
        }
        if (this.checkSameNameTableExist(connection)) {
            try {
                this.dropTable(connection);
            }
            catch (Exception exception) {
                FRLogger.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        PreparedStatement preparedStatement = null;
        Dialect dialect = DialectFactory.generateDialect(connection);
        CreateTable createTable = new CreateTable(this.getTable(), dialect);
        int n = this.columnsList.size();
        for (int i = 0; i < n; ++i) {
            createTable.addColumn(this.getColumn(i));
        }
        if (this.uniqueKeyList != null) {
            Iterator iterator = this.uniqueKeyList.iterator();
            while (iterator.hasNext()) {
                createTable.addUniqueKey((UniqueKey)iterator.next());
            }
        }
        try {
            preparedStatement = createTable.createPreparedStatement(connection);
            preparedStatement.execute();
            connection.commit();
            FRLogger.getLogger().info("Table " + this.getTable().getName() + " has been created successfully!");
            this.newTable = true;
            preparedStatement.close();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            }
        }
        if (dialect instanceof OracleDialect) {
            ((OracleDialect)dialect).createTrigger(connection);
        }
    }

    public void dropTable(Connection connection) throws Exception {
        Statement statement = null;
        try {
            statement = connection.prepareStatement("DROP TABLE " + DialectFactory.generateDialect(connection).column2SQL(this.getTable().getName()));
            statement.execute();
            FRLogger.getLogger().info("Table " + this.getTable().getName() + " has been deleted successfully");
            statement.close();
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (SQLException sQLException2) {
                FRLogger.getLogger().error(sQLException2.getMessage(), sQLException2);
            }
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addColumnsToTable(Column column, Connection connection, Table table, Dialect dialect) {
        Statement statement = null;
        try {
            AddColumn addColumn = new AddColumn(table, column, dialect);
            statement = addColumn.createPreparedStatement(connection);
            statement.execute();
            connection.commit();
        }
        catch (Exception exception) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    protected boolean findColumnInTable(String string, Connection connection, Table table) {
        PreparedStatement preparedStatement;
        Select select = new Select(table, DialectFactory.generateDialect(connection)){

            public String toStatementSQLString(Dialect dialect) {
                return this.noResultSQL();
            }
        };
        try {
            preparedStatement = select.createPreparedStatement(connection);
        }
        catch (SQLException sQLException) {
            return false;
        }
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                if (!string.equalsIgnoreCase(resultSetMetaData.getColumnName(i))) continue;
                return true;
            }
        }
        catch (SQLException sQLException) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return false;
        }
        return false;
    }
}

