/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.present;

import com.fr.base.BaseUtils;
import com.fr.base.Formula;
import com.fr.base.present.AbstractPresent;
import com.fr.base.present.Sharable;
import com.fr.data.Dictionary;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.json.JSONArray;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class DictPresent
extends AbstractPresent
implements Sharable {
    private Dictionary dict;

    public DictPresent() {
    }

    public DictPresent(Dictionary dictionary) {
        this.dict = dictionary;
    }

    public Dictionary getDictionary() {
        return this.dict;
    }

    public void setDictionary(Dictionary dictionary) {
        this.dict = dictionary;
    }

    public Object present(Object object, Calculator calculator) {
        Object object2;
        if (this.dict == null || object == null) {
            return super.present(object, calculator);
        }
        if (object instanceof Formula) {
            object = ((Formula)object).getResult();
        }
        if (object instanceof FArray) {
            FArray<Object> fArray = new FArray<Object>();
            FArray fArray2 = (FArray)object;
            for (int i = 0; i < fArray2.length(); ++i) {
                fArray.simpleAdd(this.present(fArray2.elementAt(i), calculator));
            }
            object2 = fArray;
        } else {
            object2 = object instanceof JSONArray ? this.present(BaseUtils.JSONArrayToFArray((JSONArray)object), calculator) : this.dict.get(object, calculator);
        }
        return object2 == null ? object : object2;
    }

    public Object present(Object object, Calculator calculator, ColumnRow columnRow) {
        return this.present(object, calculator);
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
        if (this.dict != null) {
            this.dict.analyzeCorrelative(calculatorProvider, exTool, columnRow);
        }
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        if (this.dict == null) {
            return super.dependence(calculatorProvider);
        }
        return this.dict.dependence(calculatorProvider);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && ("Dictionary".equals(string = xMLableReader.getTagName()) || "Dict".equals(string))) {
            this.dict = DataCoreXmlUtils.readXMLDictionary(xMLableReader);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.dict != null) {
            DataCoreXmlUtils.writeXMLDictionary(xMLPrintWriter, this.dict);
        }
    }

    public boolean equals(Object object) {
        return object instanceof DictPresent && ComparatorUtils.equals(this.dict, ((DictPresent)object).dict);
    }

    public Object clone() throws CloneNotSupportedException {
        DictPresent dictPresent = (DictPresent)super.clone();
        if (this.dict != null) {
            dictPresent.dict = (Dictionary)this.dict.clone();
        }
        return dictPresent;
    }
}

