package com.house365.test;

import java.util.ArrayList;
import java.util.List;

import net.sf.cglib.beans.BeanCopier;

public class PropertyCopy {
    
    public static void copyProperties(Object source,Object target){
        BeanCopier copier = BeanCopier.create(source.getClass(), target.getClass(), false);
        copier.copy(source, target, null);
    }
    
    public static <T> T createBeanWithProperties(Object source,Class<T> claxx) throws InstantiationException, IllegalAccessException{
        T result = claxx.newInstance();
        copyProperties(source, result);
        return result;
    }

    public static void main(String[] args) throws InstantiationException, IllegalAccessException {
        User user = new User();
        user.setId("1");
        user.setName("hugh");
        user.setAge(28);
        user.setStudent(false);
        
        Company company = new Company();
        company.setName("house365");
        List<String> address = new ArrayList<String>();
        address.add("地址1");
        address.add("地址2");
        
        company.setAddress(address);
        
        user.setCompany(company);
        
        Employee employee = new Employee();
        
        /*BeanCopier copier = BeanCopier.create(User.class, Employee.class, false);
        copier.copy(user, employee, null);*/
        copyProperties(user, employee);
        System.out.println(user);
        System.out.println(employee);
        
        Employee temp = createBeanWithProperties(user, Employee.class);
        System.out.println(temp);
        
        List<User> fromList = new ArrayList<User>();
        fromList.add(user);
        
        User user2 = new User();
        user2.setId("2");
        user2.setName("zhao");
        user2.setAge(30);
        user2.setStudent(true);
        
        Company company2 = new Company();
        company2.setName("house365.com");
        List<String> address2 = new ArrayList<String>();
        address2.add("地址3");
        address2.add("地址4");
        
        company2.setAddress(address2);
        
        user2.setCompany(company2);
        
        fromList.add(user2);
        
        System.out.println("----------");
        
        List<Employee> employees = com.house365.web.util.PropertyCopy.copyList(fromList, Employee.class);
        for (Employee emp : employees) {
            System.out.println(emp);
        }
        System.out.println("----------");
        for (User u : fromList) {
            System.out.println(u);
        }
    }

}
