package com.house365.web.util;

public class SwitchUtils {
    /**
     * 根据家庭结构id获取对应的汉字描述
     * @author zhoulei
     * @version [v1.0.0, 2015年5月6日]
     * 1.单身2.备婚3.三口之家4.三代同堂5.其他
     * @throws Exception
     * @since [产品/模块版本](可选)
     */
    public static String getMarryName(Integer marryType) throws Exception {
        switch (marryType) {
        case 1:
            return "单身";
        case 2:
            return "备婚";
        case 3:
            return "三口之家";
        case 4:
            return "三代同堂";
        default:
            return "其他";
        }
    }
    /**
     * 
     * 根据knowType获取获知途径的name
     * @author zhoulei
     * @version [v1.0.0, 2015年5月6日]
     * 1.老带新2.电商渠道3.电视 或广播4.户外媒体5.报纸或广告6.其他
     * @throws Exception
     * @since [产品/模块版本](可选)
     */
    public static String getKnowWayName(Integer knowType) throws Exception{
        switch (knowType) {
            case 1:
                return "老带新";
            case 2:
                return "电商渠道";
            case 3:
                return "电视 或广播";
            case 4:
                return "户外媒体";
            case 5:
                return "报纸或广告";
            default:
                return "其他";
            }
    }
    /**
     * 
     *  根据支付能力获取对应name
     * abilitytopay(int)支付能力 1.一次性2.商业贷加公积金3.商业贷无公积金4.其他(备注信息)
     * @author zhoulei
     * @version [v1.0.0, 2015年5月6日]
     * @since [产品/模块版本](可选)
     */
   
    public static String getAbilitytopayName(Integer abilitytopay){
        switch (abilitytopay) {
            case 1:
                return "一次性";
            case 2:
                return "商业贷加公积金";
            case 3:
                return "商业贷无公积金";
            default:
                return "其他";
            }
    }
    /**
     * 
     * 1.365电商 2.通讯录 3.老带新 4.门店/售楼处 5.其他
     * @author zhoulei
     * @version [v1.0.0, 2015年5月6日]
     * @param resource
     * @return
     * @since [产品/模块版本](可选)
     */
    public static String getResourceName(Integer resource){
        switch (resource) {
            case 1:
                return "365电商";
            case 2:
                return "通讯录";
            case 3:
                return "老带新";
            case 4:
                return "门店或售楼处";
            default:
                return "其他";
            }
    }
}
