/**
 * 
 */
package com.house365.tags.beans;

import java.util.ArrayList;
import java.util.List;

/**
 * 有效无效标识枚举类
 * 
 * @author duhui
 * 
 */
public enum DisabledFlag2 {
    /**
	 * 有效
	 */
	ENABLED(0, "有效"),

    /**
	 * 无效
	 */
	DISABLED(2, "无效");

    /**
     * 
     */

    /**
     * ID
     */
    private int id;

    /**
     * name
     */
    private String showName;

    /**
     * 构造方法
     * 
     * @param id
     *            ID
     * @param showName
     *            showName
     */
    private DisabledFlag2(int id, String showName) {
        this.setId(id);
        this.setShowName(showName);
    }

    /**
     * @return the id
     */
    public int getId() {
        return id;
    }

    /**
     * @return the name
     */
    public String getShowName() {
        return showName;
    }

    /**
     * @param id
     *            the id to set
     */
    private void setId(int id) {
        this.id = id;
    }

    /**
     * @param showName
     *            the showName to set
     */
    private void setShowName(String showName) {
        this.showName = showName;
    }

    /**
     * 获取枚举列表
     * 
     * @return 枚举列表
     */
    public static final List<DisabledFlag2> list() {
        return new ArrayList<DisabledFlag2>() {
            /**
             * 
             */
            private static final long serialVersionUID = 1L;

            {
                add(ENABLED);
                add(DISABLED);
            }
        };
    }

    /**
     * 通过ID查询枚举对象
     * 
     * @param id
     *            ID
     * @return 枚举对象
     */
    public static final DisabledFlag2 getById(int id) {
        for (DisabledFlag2 importExportFlag : list()) {
            if (id == importExportFlag.getId()) {
                return importExportFlag;
            }
        }
        return null;
    }
}
