/*
 * Copyright (C), 2002-2015, 江苏三六五网络股份有限公司
 * FileName: AppChannel.java
 * Author:   duhui
 * Date:     2015年3月6日 下午1:54:18
 * Description:     
 * History: 
 * <author>      <time>      <version>    <desc>
 * 修改人姓名                          修改时间                        版本号                                 描述
 */
package com.house365.tags.beans;

import java.util.ArrayList;
import java.util.List;

public enum AppChannel {

    /**
     * 手机
     */
    APP(1, "手机"),

    /**
     * 触屏
     */
    TOUCH(2, "触屏"),

    /**
     * IPAD
     */
    IPAD(3, "IPAD");
    
    /**
     * ID
     */
    private int id;

    /**
     * name
     */
    private String showName;
    
    /**
     * 构造方法
     * 
     * @param id
     *            ID
     * @param showName
     *            showName
     */
    private AppChannel(int id, String showName) {
        this.setId(id);
        this.setShowName(showName);
    }
    
    /**
     * @return the id
     */
    public int getId() {
        return id;
    }

    /**
     * @return the name
     */
    public String getShowName() {
        return showName;
    }

    /**
     * @param id
     *            the id to set
     */
    private void setId(int id) {
        this.id = id;
    }

    /**
     * @param showName
     *            the showName to set
     */
    private void setShowName(String showName) {
        this.showName = showName;
    }
    
    /**
     * 获取枚举列表
     * 
     * @return 枚举列表
     */
    public static final List<AppChannel> list() {
        return new ArrayList<AppChannel>() {
            /**
             * 
             */
            private static final long serialVersionUID = 1L;

            {
                add(APP);
                add(TOUCH);
                add(IPAD);
            }
        };
    }
    
    /**
     * 通过ID查询枚举对象
     * 
     * @param id
     *            ID
     * @return 枚举对象
     */
    public static final AppChannel getById(int id) {
        for (AppChannel importExportFlag : list()) {
            if (id == importExportFlag.getId()) {
                return importExportFlag;
            }
        }
        return null;
    }
}
