/*
 * Copyright (C), 2002-2015, 江苏三六五网络股份有限公司
 * FileName: GetNewsInfo.java
 * Author:   duhui
 * Date:     2015年1月23日 下午3:07:34
 * Description:     
 * History: 
 * <author>      <time>      <version>    <desc>
 * 修改人姓名                          修改时间                        版本号                                 描述
 */
package com.house365.tags;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

/**
 * 调用资讯接口 取得资讯信息
 *
 * @author duhui
 * @version [v1.0.0, 2015年1月23日]
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
public class GetNewsInfo extends RequestContextAwareTag {

    /**
     */
    private static final long serialVersionUID = 1L;

    /**
     * 新房提供的接口地址
     */
    private static final String newsUrl = "http://mapi.house365.com/cms/mobile_news.php?method=one_news&baseInfo=1&n_content=1";

    /**
     * 城市ID
     */
    public static final String CITY_ID = "cityId";

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(GetNewsInfo.class);

    public Map<String, String> getNewsMap(String newsId, String cityId) {

        Map<String, Object> newsInfo = getNewsObject(newsId, cityId);
        if (null == newsInfo || "".equals(newsInfo)) {
            LOGGER.error("研发中心接口异常：资讯为空！资讯ID = " + newsId);
        }
        // 封装数据返回  update by jiangzhou 2015-07-21 修改数据
        Map<String, String> map = new HashMap<String, String>();
        map.put("id", newsInfo.get("n_id") == null ? "" : newsInfo.get("n_id").toString());
        map.put("title", newsInfo.get("n_title") == null ? "" : newsInfo.get("n_title").toString());
        map.put("subtitle", newsInfo.get("n_subtitle") == null ? "" : newsInfo.get("n_subtitle").toString());
        map.put("thumb", newsInfo.get("n_pic") == null ? "" : newsInfo.get("n_pic").toString());
        map.put("time", newsInfo.get("n_addtime") == null ? "" : newsInfo.get("n_addtime").toString());
        map.put("desc", newsInfo.get("n_description") == null ? "" : newsInfo.get("n_description").toString());
        map.put("link", newsInfo.get("web_url") == null ? "" : newsInfo.get("web_url").toString());

        return map;
    }

    /**
     * 
     * 获取接口JSON字符串
     *
     * @author duhui
     * @version [v1.0.0, 2015年1月24日]
     */
    private String getJsonData(String urlString) throws Exception {
        /**
         * 获取接口JSON字符串
         */
        String jsonStr = "";
        try {
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String line;
            while ((line = in.readLine()) != null) {
                jsonStr += line;
            }
            in.close();
        } catch (Exception e) {
            LOGGER.error("研发中心接口异常：获取资讯接口数据为空！");
        }
        return jsonStr;
    }

    /**
     * 
     * 将字符串解析成对象
     *
     * @author duhui
     * @version [v1.0.0, 2015年1月24日]
     */
    private Map<String, Object> getNewsObject(String newsId, String cityId) {

        try {
            StringBuffer buffer = new StringBuffer(newsUrl);
            // 不影响开发
            if (null == cityId || "".equals(cityId)) {
                cityId = "nj";
            }
            buffer.append("&city=" + cityId);
            buffer.append("&id=" + newsId);
            // 接口地址 获取JSON字符串
            String jsonStr = getJsonData(buffer.toString());
            Map<String, Object> newsInfo = parseJSON2Map(jsonStr);
            return newsInfo;
        } catch (Exception e) {
            LOGGER.error("研发中心接口异常：解析研发中心接口提供资讯JSON字符串异常！");
        }
        return null;
    }

    // JSON转换为Map add by jiangzhou
    public static Map<String, Object> parseJSON2Map(String jsonStr) {
        Map<String, Object> map = new HashMap<String, Object>();
        // 最外层解析
        JSONObject json = JSONObject.fromObject(jsonStr);
        for (Object k : json.keySet()) {
            Object v = json.get(k);
            // 如果内层还是数组的话，继续解析
            if (v instanceof JSONArray) {
                List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                @SuppressWarnings("unchecked")
                Iterator<JSONObject> it = ((JSONArray) v).iterator();
                while (it.hasNext()) {
                    JSONObject json2 = it.next();
                    list.add(parseJSON2Map(json2.toString()));
                }
                map.put(k.toString(), list);
            } else {
                map.put(k.toString(), v);
            }
        }
        return map;
    }

    /**
     * 占时未使用
     */
    protected int doStartTagInternal() throws Exception {
        return 0;
    }

}
