/*
 * Copyright (C), 2002-2015, 江苏三六五网络股份有限公司
 * FileName: AbstractNewHouseSelectTag.java
 * Author:   duhui
 * Date:     2015年1月23日 上午10:41:37
 * Description:     
 * History: 
 * <author>      <time>      <version>    <desc>
 * 修改人姓名                          修改时间                        版本号                                 描述
 */
package com.house365.tags;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

import com.house365.tags.beans.NewHouseItem;

import java.util.List;
import java.util.Locale;

/**
 * 公共标签 新房选择抽象类
 *
 * @author duhui
 * @version [v1.0.0, 2015年1月23日]
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
public abstract class AbstractNewHouseSelectTag<T extends NewHouseItem> extends RequestContextAwareTag {
    /**
     */
    private static final long serialVersionUID = 1L;
    
    private String name;
   
    private String span = "span6";
    
    private String placeHolderMessageCode;
   
    private boolean useChosen = true;
   
    private boolean showAllOption = false;
    
    private String style;
    
    private boolean required = false;
   
    private String value;
   
    private String clazz;
   
    private boolean multiple = false;

    protected String getName() {
        if (name == null) {
            return getDefaultName();
        }
        return name;
    }

    protected String getSpan() {
        return span;
    }

    protected String getPlaceHolderMessageCode() {
        if (placeHolderMessageCode == null) {
            return getDefaultPlaceHolderMessageCode();
        }
        return placeHolderMessageCode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSpan(String span) {
        this.span = span;
    }

    public void setPlaceHolderMessageCode(String placeHolderMessageCode) {
        this.placeHolderMessageCode = placeHolderMessageCode;
    }

    public boolean isUseChosen() {
        return useChosen;
    }

    public void setUseChosen(boolean useChosen) {
        this.useChosen = useChosen;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isShowAllOption() {
        return showAllOption;
    }

    public void setShowAllOption(boolean showAllOption) {
        this.showAllOption = showAllOption;
    }

    public String getStyle() {
        return style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isRequired() {
        return required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getClazz() {
        return clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public boolean isMultiple() {
        return multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    protected abstract String getDefaultName();

    protected String getDefaultPlaceHolderMessageCode() {
        return "common.pleaseSelect";
    }

    protected WebApplicationContext getApplicationContext() {
        return getRequestContext().getWebApplicationContext();
    }

    protected MessageSource getMessageSource() {
        return getRequestContext().getMessageSource();
    }

    protected String getPlaceHoldMessage() {
        Locale locale = LocaleContextHolder.getLocale();
        return getMessageSource().getMessage(getPlaceHolderMessageCode(), null, locale);
    }

    @Override
    protected int doStartTagInternal() throws Exception {
        StringBuilder finalClazz = new StringBuilder();
        if (isUseChosen()) {
            finalClazz.append("chosen-with-diselect");
        }

        if (StringUtils.isNotEmpty(getSpan())) {
            finalClazz.append("  ").append(getSpan()).append(" ");
        }

        if (StringUtils.isNotEmpty(getClazz())) {
            finalClazz.append("  ").append(getClazz()).append(" ");
        }

        if (isRequired()) {
            finalClazz.append(" required ");
        }

        StringBuilder builder = new StringBuilder();
        builder.append("<select name=\"" + getName() + "\" class=\"" + finalClazz + " \" data-placeholder=\"" + getPlaceHoldMessage() + "\"");
        if (StringUtils.isNotEmpty(getStyle())) {
            builder.append(" style=\"" + getStyle() + "\" ");
        }
        if (isRequired()) {
            builder.append(" required=\"required\" ");
        }
        if (isMultiple()) {
            builder.append(" multiple=\"multiple\" ");
        }
        builder.append(">");

        // 如果显示全部，那么就不会出现第一个是空白的情况
        if (isShowAllOption()) {
            builder.append("<option value=\"\">" + getMessageSource().getMessage("common.option.all", null, LocaleContextHolder.getLocale()) + "</option>");
        } else {
            if (StringUtils.isEmpty(getValue())) {
                builder.append("<option value=\"\" selected=\"selected\"></option>");
            } else {
                builder.append("<option value=\"\"></option>");
            }
        }

        for (T obj : getList()) {
            String optionValue = getOptionValue(obj).toString();
            String optionLabel = getOptionLabel(obj);
            if (optionValue.equals(getValue())) {
                builder.append("<option value=\"" + optionValue + "\" selected=\"selected\">" + optionLabel + "</option>");
            } else {
                builder.append("<option value=\"" + optionValue + "\">" + optionLabel + "</option>");
            }

        }
        builder.append("</select>");
        pageContext.getOut().write(builder.toString());

        return SKIP_BODY;
    }

    protected abstract List<T> getList();

    protected Object getOptionValue(T obj) {
        return obj.getHouseName()+"-"+obj.getHouseId()+"-"+obj.getCityId()+"-"+obj.getAreaId()+"-"+obj.getAreaName();
    }

    protected abstract String getOptionLabel(T obj);
}

