package com.house365.web.system.listener;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.house365.web.util.ContextUtils;

/**
 * 初始化全局参数和系统字典
 * 
 */
public class ApplicationListener implements ServletContextListener {

    /**
     * 日志记录工具
     */
    private static final Logger LOGGER = LoggerFactory
            .getLogger(ApplicationListener.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        // 设置全局应用上下文
        ServletContext application = servletContextEvent.getServletContext();
        ContextUtils.setApplication(application);
//        LOGGER.debug("启动应用");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        LOGGER.debug("停止应用");
    }
}
