package com.house365.web.filter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 防止Xss攻击请求<br>
 * 实现对请求的拦截，并通过设定的方式进行特殊字符串替换
 * 
 * @author duhui
 * @version 2.0.0, 2015年01月12日
 * @see XSSFilter#doFilter(ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
 */
public class XssHttpServletRequestWrapper extends ServletRequestWrapper implements HttpServletRequest, ServletRequest {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(XssHttpServletRequestWrapper.class);

    /**
     * 请求对象
     */
    private HttpServletRequest request = null;

    /**
     * 是否替换特殊字符
     */
    private boolean trimToNull = true;

    /**
     * 特殊字符替换规则
     */
    private Map<String, String> escapeCharacters = null;

    /**
     * 构造方法
     * 
     * @param request 请求对象
     * @param trimToNull 是否将trim后为空的字符串设置为null
     * @param escapeCharacters 特殊字符替换规则
     */
    public XssHttpServletRequestWrapper(ServletRequest request, boolean trimToNull, Map<String, String> escapeCharacters) {
        super(request);
        this.request = (HttpServletRequest) request;
        this.trimToNull = trimToNull;
        this.escapeCharacters = escapeCharacters;
    }

    /**
     * 
     * 功能描述: 过滤清洗请求参数<br>
     * 
     * @author duhui 
     * @version 2.0.0, 2015年01月12日
     * @param parameterMap 请求参数
     * @return 清洗后请求参数
     * @see #getParameterMap()
     */
    private Map<String, String[]> sanitizeParamMap(Map<String, String[]> parameterMap) {
        Map<String, String[]> sanitizeParameterMap = new HashMap<String, String[]>();
        if (parameterMap == null) {
            return sanitizeParameterMap;
        }
        for (Entry<String, String[]> entry : parameterMap.entrySet()) {
            final String key = entry.getKey();
            String[] parameterMapValues = entry.getValue();
            String[] sanitizeParameterMapValues = new String[parameterMapValues.length];
            if (!key.equals("content_adfgsgasfsapqoeruoi")) {
                for (int i = 0; i < parameterMapValues.length; i++) {
                    sanitizeParameterMapValues[i] = cleanXSS(key, parameterMapValues[i]);
                }
                sanitizeParameterMap.put(key, sanitizeParameterMapValues);
            } else {
                sanitizeParameterMap.put(key, parameterMapValues);
            }
        }
        return sanitizeParameterMap;
    }

    /**
     * 
     * 功能描述: 过滤非法字符串<br>
     * 
     * @author duhui 
     * @version 2.0.0, 2015年01月12日
     * @param name 名称
     * @param value 取值
     * @return 过滤清理后内容
     */
    private String cleanXSS(String name, String value) {
        String result = value;
        result = convert(result);
        if (null == result) {
            return result;
        }
        // result = result.trim();
        // result = result.replaceAll("<", "&#60;").replaceAll(">", "&#62;");
        result = result.replaceAll("eval\\((.*)\\)", "");
        result = result.replaceAll("[\\\"\\\'][\\s]*javascript:(.*)[\\\"\\\']", "\"\"");
        LOGGER.debug("XSS过滤:过滤前: [" + value + "],过滤后：[" + result + "]");
        return result;
    }

    public String getAuthType() {
        return request.getAuthType();
    }

    public String getContextPath() {
        return request.getContextPath();
    }

    public Cookie[] getCookies() {
        return request.getCookies();
    }

    public long getDateHeader(String name) {
        return request.getDateHeader(name);
    }

    public String getHeader(String name) {
        String value = request.getHeader(name);
        if (value == null)
            return null;
        return cleanXSS(name, value);
    }

    public Enumeration<?> getHeaderNames() {
        return request.getHeaderNames();
    }

    public Enumeration<?> getHeaders(String arg0) {
        return request.getHeaders(arg0);
    }

    public int getIntHeader(String arg0) {
        return request.getIntHeader(arg0);
    }

    public String getMethod() {
        return request.getMethod();
    }

    public String getPathInfo() {
        return request.getPathInfo();
    }

    public String getPathTranslated() {
        return request.getPathTranslated();
    }

    public String getQueryString() {
        return request.getQueryString();
    }

    public String getRemoteUser() {
        return request.getRemoteUser();
    }

    public String getRequestURI() {
        return request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return request.getRequestURL();
    }

    public String getRequestedSessionId() {
        return request.getRequestedSessionId();
    }

    public String getServletPath() {
        return request.getServletPath();
    }

    public HttpSession getSession() {
        return request.getSession();
    }

    public HttpSession getSession(boolean create) {
        return request.getSession(create);
    }

    public Principal getUserPrincipal() {
        return request.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return request.isRequestedSessionIdFromURL();
    }

    /**
     * 
     * @deprecated As of Version 2.1 of the Java Servlet API, use {@link #isRequestedSessionIdFromURL} instead.
     * 
     */
    public boolean isRequestedSessionIdFromUrl() {
        return request.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdValid() {
        return request.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String arg0) {
        return request.isUserInRole(arg0);
    }

    public Object getAttribute(String arg0) {
        return request.getAttribute(arg0);
    }

    public Enumeration<?> getAttributeNames() {
        return request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return request.getCharacterEncoding();
    }

    public int getContentLength() {
        return request.getContentLength();
    }

    public ServletRequest getRequest() {
        return request;
    }

    public void setRequest(ServletRequest request) {
        this.request = (HttpServletRequest) request;
    }

    public String getContentType() {
        return request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return request.getInputStream();
    }

    public String getLocalAddr() {
        return request.getLocalAddr();
    }

    public String getLocalName() {
        return request.getLocalName();
    }

    public int getLocalPort() {
        return request.getLocalPort();
    }

    public Locale getLocale() {
        return request.getLocale();
    }

    public Enumeration<?> getLocales() {
        return request.getLocales();
    }

    public String getParameter(String parameter) {
        String[] vals = getParameterMap().get(parameter);
        if (vals != null && vals.length > 0) {
            return vals[0];
        } else {
            return null;
        }
    }

    @SuppressWarnings("unchecked")
    public Map<String, String[]> getParameterMap() {
        return sanitizeParamMap(request.getParameterMap());
    }

    public Enumeration<?> getParameterNames() {
        return request.getParameterNames();
    }

    public String[] getParameterValues(String parameter) {
        return getParameterMap().get(parameter);
    }

    public String getProtocol() {
        return request.getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        return request.getReader();
    }

    /**
     * 
     * @deprecated As of Version 2.1 of the Java Servlet API, use {@link ServletContext#getRealPath} instead.
     * 
     */
    public String getRealPath(String path) {
        return request.getRealPath(path);
    }

    public String getRemoteAddr() {
        return request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return request.getRemoteHost();
    }

    public int getRemotePort() {
        return request.getRemotePort();
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return request.getRequestDispatcher(arg0);
    }

    public String getScheme() {
        return request.getScheme();
    }

    public String getServerName() {
        return request.getServerName();
    }

    public int getServerPort() {
        return request.getServerPort();
    }

    public boolean isSecure() {
        return request.isSecure();
    }

    public void removeAttribute(String arg0) {
        request.removeAttribute(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        request.setAttribute(arg0, arg1);
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        request.setCharacterEncoding(arg0);
    }

    /**
     * 转换特殊字符
     * 
     * @param source 原数据
     * @return 转换后字符
     */
    public String convert(String source) {
        if (trimToNull) {
            source = StringUtils.trimToNull(source);
        }
        if (null == source) {
            return null;
        }
        for (String from : escapeCharacters.keySet()) {
            String to = escapeCharacters.get(from);
            source = source.replaceAll(from, to);
        }
        return source;
    }
}
