package com.house365.web.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.StringUtils;

import com.house365.rest.context.CmConstant;
import com.house365.rest.context.ServiceConstant;

/**
 * 城市过滤器<br>
 * 增加城市信息条件
 */
public class AppCityFilter implements Filter {

    /**
     * 需要排除的页面字符串
     */
    private String excludedPages;

    /**
     * 需要排除的页面列表
     */
    private List<String> excludedPageList = new ArrayList<String>();

    /**
     * Default constructor.
     */
    public AppCityFilter() {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException,
            ServletException {
        boolean isExcludedPage = false;
        // 判断是否在过滤url之外
        for (String page : excludedPageList) {
            if (((HttpServletRequest) request).getServletPath().equals(page)) {
                isExcludedPage = true;
                break;
            }
        }
        if (!isExcludedPage) {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest servletRequest = (HttpServletRequest) request;
                HttpSession session = servletRequest.getSession(false);
                String cityId = null;
                if (null != session) {
                    Object cityIdObj = session.getAttribute(ServiceConstant.CITY_ID);
                    if (null != cityIdObj) {
                        cityId = cityIdObj.toString();
                        if (null == session.getAttribute(CmConstant.CITY_ID)) {
                           /* session.setAttribute(CmConstant.CITY_NAME, "南京");
                            session.setAttribute(CmConstant.CITY_ID, "nj");*/
                            response.getWriter().write("<h1 style='color:red;'>登录失败，无权访问，请重新登录！</h1>");
                            return;
                        }
                    }
                }
                @SuppressWarnings("unchecked")
                Map<String, Object> parameterMap = new HashMap<String, Object>(servletRequest.getParameterMap());
                if (StringUtils.isNotEmpty(cityId)) {
                    parameterMap.put("search_EQ_cityId", new String[] { cityId });
                    parameterMap.put("search_EQ_city", new String[] { cityId });
                }
                ParameterRequestWrapper newRequest = new ParameterRequestWrapper(servletRequest, parameterMap);
                request = newRequest;
            }
        }
        chain.doFilter(request, response);
    }

    /**
     * @param filterConfig 过滤器配置信息
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        excludedPages = filterConfig.getInitParameter("excludedPages");
        if (StringUtils.isNotEmpty(excludedPages)) {
            String[] excludedPageArray = excludedPages.split(",");
            for (String excludedPage : excludedPageArray) {
                excludedPageList.add(excludedPage);
            }
        }
        return;
    }
}
