/*
 * Copyright (C), 2002-2015, 365金融研发中心
 * FileName: //文件名
 * Author:   Administrator
 * Date:     2015年1月30日 上午11:24:12
 * Description: //模块目的、功能描述      
 * History: //修改记录
 * <author>      <time>      <version>    <desc>
 * 修改人姓名             修改时间            版本号                  描述
 */
package com.house365.web.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

/**
 * 〈一句话功能简述〉 〈功能详细描述〉
 * 
 * @author Administrator
 */
public class DateConverter implements Converter<String, Date> {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(DateConverter.class);
    /**
     * 线程安全日期格式化对象
     */
    private static final ThreadLocal<DateFormat> DATE_TIME_FORMAT = new ThreadLocal<DateFormat>() {
        public DateFormat get() {
            DateFormat dateFormat = super.get();
            if (null == dateFormat) {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                super.set(dateFormat);
            }
            return dateFormat;
        };
    };

    /*
     * (non-Javadoc)
     * @see
     * org.springframework.core.convert.converter.Converter#convert(java.lang
     * .Object)
     */
    public Date convert(String source) {
        try {
            if (StringUtils.isNotEmpty(source)) {
                return DATE_TIME_FORMAT.get().parse(source);
            }
        } catch (ParseException ex) {
            LOGGER.warn(ex.getMessage(), ex);
        }
        return null;
    }

}
