package com.house365.tags;

/**
 * AJAX分页标签<li>翻页时只局部刷新
 * 
 * @author duhui
 * 
 */
public class AjaxPaginationTag extends PaginationTag {
    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /**
     * 请求的baseUrl
     */
    private String baseUrl;

    /**
     * 需要刷新(加载数据到的)页面元素
     */
    private String contextSel;

    /**
     * 设置需要刷新(加载数据到的)页面元素
     * 
     * @param contextSel
     *            需要刷新(加载数据到的)页面元素
     */
    public void setContextSel(String contextSel) {
        this.contextSel = contextSel;
    }

    /**
     * 设置请求的baseUrl
     * 
     * @param baseUrl
     *            请求的baseUrl
     */
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    protected String buildHrefAttribute(int number) {
        StringBuilder builder = new StringBuilder();
        builder.append("javascript:House365Util.ajaxTurn2Page(\"" + contextSel + "\", \""
                + baseUrl + "\", " + number + ");");
        return builder.toString();
    }
}