package com.house365.rest.context;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * @author duhui
 * @version [v1.0.0, 2015年1月24日]
 */
public class Parameter implements Serializable {
	/**
	 * 序列化标识
	 */
	private static final long serialVersionUID = 1L;

	// 参数堆，存取值用
	private Map<String, Object> args = new HashMap<String, Object>();

	public Map<String, Object> getArgs() {
		return args;
	}

	public void setArgs(Map<String, Object> args) {
		this.args = args;
	}

	public void addArg(String key, Object value) {
		args.put(key, value);
	}

	public void removeArg(String key) {
		args.remove(key);
	}

	public Object getArg(String key) {
		return args.get(key);
	}

	public boolean containsArg(String key) {
		return args.containsKey(key);
	}
}
