package com.house365.rest.context;

import com.house365.rest.exception.ServiceRunException;

/**
 * @author duhui
 * @version [v1.0.0, 2015年1月24日]
 */
public interface IService extends ITranscation {
    /**
     * 执行服务
     *
     * @param parameter 服务输入，不包含服务配置和控制信息
     * @return 执行结果，目前为对json的封装，可以为null
     * @throws ServiceRunException 如果运行的服务发生异常则抛出服务运行时异常
     */
    Object exectue(Parameter parameter) throws ServiceRunException;

    /**
     * 判断服务是否具有控制逻辑
     *
     * @return 是否判断
     */
    boolean isControlService();

    /**
     * 判断服务是否需要记录日志
     *
     * @return 是否判断
     */
    boolean isLogService();

    /**
     * 判断服务是否需要监控
     *
     * @return 是否判断
     */
    boolean isMonitorService();

}
