package com.house365.dao.system.interfaces;

import java.util.Collection;
import java.util.List;

import com.house365.beans.system.QueryParams;

/**
 * 公共DAO接口<br>
 */
public interface Dao<T> {

    /**
     * 保存<br>
     * 
     * @param entity
     *            实体
     * @return
     * @see
     */
    Integer save(T entity);
    
    /**
     * 批量插入
     * @author zhaodeshan
     * @version [版本号, 2015年2月4日]
     * @param entities
     * @since [产品/模块版本](可选)
     */
    void save(Collection<T> entities);

    /**
     * 修改 <br>
     * 
     * @param entity
     * @see
     */
    void update(T entity);
    
    /**
     * 批量更新
     * @author zhaodeshan
     * @version [版本号, 2015年2月4日]
     * @param entities
     * @since [产品/模块版本](可选)
     */
    void update(Collection<T> entities);

    /**
     * 删除<br>
     * 
     * @param id
     * @see
     */
    void delete(Integer id);

    /**
     * 批量删除<br>
     * 
     * @param ids
     * @see
     */
    void deleteByIds(Integer... ids);

    /**
     * 
     * 通过id查询 <br>
     * 
     * @param id
     * @return
     * @see
     */
    T getById(Integer id);

    /**
     * 
     * 分页查询 <br>
     * 
     * @param queryParams
     * @return
     * @see
     */
    List<T> queryByPage(QueryParams<?> queryParams);

    /**
     * 
     * 获取所有数据 <br>
     * 
     * @return
     * @see
     */
    List<T> queryAll();

    /**
     * 
     * 获取符合条件的所有数据 <br>
     * 
     * @return
     * @see
     */
    List<T> queryAll(QueryParams<?> queryParams);

    /**
     * 
     * 获取总数 <br>
     * 
     * @param params
     * @return
     * @see
     */
    int getTotalCount(Object params);
}
