/**
 * Description: KlfSmsCode业务接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-07-06 下午 14:00:59
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-07-06   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import java.util.Map;

import com.house365.beans.entity.CmSmsCodeEntity;
import com.house365.service.system.Interfaces.Service;


/**
 * KlfSmsCode业务接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-07-06
 * @see
 * @since 1.0
 */
public interface ICmSmsCodeService<T extends CmSmsCodeEntity> extends Service<T> {
	/**
     * 
     * 根据手机号查询记录
     */
    public CmSmsCodeEntity getByPhone(String phone);
    
    /**
     * 
     * 根据手机号查询该短信发送次数
     */
    public Map<String,Object> findAllSmsRecord(String phone);
    
    /**
     * 
     * 更新短信发送次数
     */
    public Integer recordSmsTimes(Map<String,Object> param);
}