/**
 * Description: CmLotteryRule业务接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-19 上午 11:24:24
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-19   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import com.house365.beans.entity.CmLotteryRuleEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.service.system.Interfaces.Service;

/**
 * CmLotteryRule业务接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-19
 * @see
 * @since 1.0
 */
public interface ICmLotteryRuleService<T extends CmLotteryRuleEntity> extends Service<T> {
 

    /**
     * 
     * 功能描述: <br>
     * 签到大转盘抽奖
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年8月21日]
     * @param userId 用户ID
     * @param useridType
     * @param cityKey
     * @throws Exception
     * @since [产品/模块版本](可选)
     */
    CmLotteryRuleEntity transGetSignedLotteryScore(String userId, Integer useridType, String cityKey) throws Exception;
    
    /**
     * 
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年8月21日]
     * @param userId
     * @param cityId
     * @return
     * @throws Exception 
     * @since [产品/模块版本](可选)
     */
    Integer transGetSignedScore(CmUserEntity cmUser, String cityKey) throws Exception;
}