/**
 * Description: KlfCity业务实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-07-10 上午 10:47:22
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-07-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.system.QueryParams;
import com.house365.service.system.impl.DefaultServiceImpl;

import com.house365.ws.dao.interfaces.IKlfCityDao;
import com.house365.ws.service.interfaces.IKlfCityService;
import com.house365.beans.entity.KlfCityEntity;

/**
 * KlfCity业务实现类<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-07-10
 * @see
 * @since 1.0
 */
@Service("klfCityService")
public class KlfCityServiceImpl<T extends KlfCityEntity> extends DefaultServiceImpl<T> implements IKlfCityService<T> {
	/**
	 * 自动注入的数据访问对象
	 */
	@Autowired
	private IKlfCityDao<T> klfCityDao;

    @Override
    protected Dao<T> getDao() {
        return klfCityDao;
    }
}