/**
 * Description: CmSmsCode业务实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-07-06 下午 14:00:59
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-07-06   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.house365.beans.entity.CmSmsCodeEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICmSmsCodeDao;
import com.house365.ws.service.interfaces.ICmSmsCodeService;

/**
 * CmSmsCode业务实现类<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-07-06
 * @see
 * @since 1.0
 */
@Service("cmSmsCodeService")
public class CmSmsCodeServiceImpl<T extends CmSmsCodeEntity> extends DefaultServiceImpl<T> implements ICmSmsCodeService<T> {
	/**
	 * 自动注入的数据访问对象
	 */
	@Autowired
	private ICmSmsCodeDao<T> CmSmsCodeDao;

    @Override
    protected Dao<T> getDao() {
        return CmSmsCodeDao;
    }
    
    /**
     * 
     * 根据手机号查询记录
     */
    public CmSmsCodeEntity getByPhone(String phone) {
        
        return CmSmsCodeDao.getByPhone(phone);
    }

    /**
     * 
     * 根据手机号查询该短信发送信息
     */
    @Override
    public Map<String,Object> findAllSmsRecord(String phone) {
        return CmSmsCodeDao.findAllSmsRecord(phone);
    }

    /**
     * 
     * 更新短信发送次数
     */
    public Integer recordSmsTimes(Map<String, Object> param) {
        return CmSmsCodeDao.recordSmsTimes(param);
    }
}