/**
 * Description: CmSeckillBooked业务实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-11-29 下午 14:08:43
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-11-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.system.QueryParams;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICmSeckillBookedDao;
import com.house365.ws.service.interfaces.ICmSeckillBookedService;
import com.house365.beans.entity.CmSeckillBookedEntity;

/**
 * CmSeckillBooked业务实现类<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-11-29
 * @see
 * @since 1.0
 */
@Service("cmSeckillBookedService")
public class CmSeckillBookedServiceImpl<T extends CmSeckillBookedEntity> extends DefaultServiceImpl<T> implements ICmSeckillBookedService<T> {
	/**
	 * 自动注入的数据访问对象
	 */
	@Autowired
	private ICmSeckillBookedDao<T> cmSeckillBookedDao;

    @Override
    protected Dao<T> getDao() {
        return cmSeckillBookedDao;
    }

    @Override
    public void deleteCmSeckillBookedByGoodId(Integer id) {
        cmSeckillBookedDao.deleteCmSeckillBookedByGoodId(id);
    }
    
    
    
    
}