/**
 * Description: CmProductStat业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-03-16 下午 17:11:49
 * <p/>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-03-16   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.CmCreditGoodsEntity;
import com.house365.beans.entity.CmProductStatEntity;
import com.house365.beans.system.Page;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICmCreditGoodsDao;
import com.house365.ws.dao.interfaces.ICmProductStatDao;
import com.house365.ws.interfaces.server.ICmCreditGoods;
import com.house365.ws.service.interfaces.ICmProductStatService;
import com.house365.ws.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * CmProductStat业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-03-16
 * @see
 * @since 1.0
 */
@Service("cmProductStatService")
public class CmProductStatServiceImpl<T extends CmProductStatEntity> extends DefaultServiceImpl<T> implements ICmProductStatService<T> {
    Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private ICmProductStatDao<T> cmProductStatDao;

    @Autowired
    private ICmCreditGoodsDao cmCreditGoodsDao;


    @Override
    protected Dao<T> getDao() {
        return cmProductStatDao;
    }


    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    @Override
    public void initialData() {
        cmProductStatDao.truncateTable();
        cmProductStatDao.initialData();
    }

    @Override
    public void saveOrUpdate(CmCreditGoodsEntity goodsEntity) {
        if (goodsEntity == null) {
            return;
        }
        cmProductStatDao.saveOrUpdate(goodsEntity);
    }

    /**
     * refresh product stat data
     */
    @Override
    public void refreshTask() {
        if (cmProductStatDao.queryAll().isEmpty()) {
            cmProductStatDao.initialData();
        }

        String yesterday = getYesterday();
        String today = DateUtils.dateToString(new Date(), DateUtils.DATE);

        Page page = new Page();
        page.setCurrentPage(1);
        page.setPageSize(Integer.MAX_VALUE);

        QueryParams<CmProductStatEntity> productStatEntityQueryParams = new QueryParams<>();
        Map<String, Object> statMap = new HashMap<>();
        statMap.put("EQ_statDate", yesterday);
        productStatEntityQueryParams.setSearchParams(statMap);
        productStatEntityQueryParams.setPaging(page);
        List<T> productStatEntities = this.queryByPage(productStatEntityQueryParams);

        if (!productStatEntities.isEmpty()) {
            for (CmProductStatEntity cmProductStatEntity : productStatEntities) {
                int productId = cmProductStatEntity.getProductId();
                CmCreditGoodsEntity creditGoodsEntity = (CmCreditGoodsEntity) cmCreditGoodsDao.getById(productId);
                if(creditGoodsEntity != null) {
                    //refresh yesterday data
                    creditGoodsEntity.setDescription(yesterday);
                    if (creditGoodsEntity.getStatus() == 1) {
                        creditGoodsEntity.setStock(0);
                    }
                    saveOrUpdate(creditGoodsEntity);

                    //create today data
                    creditGoodsEntity.setDescription(today);
                    saveOrUpdate(creditGoodsEntity);
                }
            }
        }

        // add today seckill products
        List<CmCreditGoodsEntity> seckills = cmCreditGoodsDao.getTodaySeckills();
        for (CmCreditGoodsEntity seckill : seckills) {
            seckill.setDescription(today);
            saveOrUpdate(seckill);
        }


    }

    private static String getYesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DAY_OF_MONTH, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(calendar.getTime());
    }

    @Override
    public List<CmProductStatEntity> statByCity() {
        return cmProductStatDao.statByCity();
    }

    @Override
    public List<CmProductStatEntity> statByDate(String cityName) {
        return cmProductStatDao.statByDate(cityName);
    }


}
