/**
 * Description: CmInviteRecord业务实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-10-15 上午 09:33:17
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-10-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.CmCreditRecordEntity;
import com.house365.beans.entity.CmInviteRecordEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICmCreditRecordDao;
import com.house365.ws.dao.interfaces.ICmInviteRecordDao;
import com.house365.ws.service.interfaces.ICmInviteRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * CmInviteRecord业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-10-15
 * @see
 * @since 1.0
 */
@Service("cmInviteRecordService")
public class CmInviteRecordServiceImpl<T extends CmInviteRecordEntity> extends DefaultServiceImpl<T> implements ICmInviteRecordService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private ICmInviteRecordDao<T> cmInviteRecordDao;
    @Autowired
    private ICmCreditRecordDao<CmCreditRecordEntity> creditRecordDao;

    @Override
    protected Dao<T> getDao() {
        return cmInviteRecordDao;
    }

    @Override
    public CmCreditRecordEntity transInviteUser(Map<String, Object> map) {

        try {
            //获取用户信息
            CmUserEntity userEntity = (CmUserEntity) (map.get("currentInviterUser"));
            Integer recordId = Integer.parseInt(map.get("recordId").toString());
            //添加积分记录
            CmCreditRecordEntity recordEntity = creditRecordDao.saveInviteRecord(userEntity, recordId);
            //积分余额
            Integer remainingAmount = userEntity.getCredits() + recordEntity.getAmount();
            recordEntity.setRemainingAmount(remainingAmount);
            return recordEntity;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}