/**
 * Description: CmDeliveryAddress业务实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-10 下午 17:06:12
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.house365.beans.entity.CmDeliveryAddressEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICmDeliveryAddressDao;
import com.house365.ws.service.interfaces.ICmDeliveryAddressService;

/**
 * CmDeliveryAddress业务实现类<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmDeliveryAddressService")
public class CmDeliveryAddressServiceImpl<T extends CmDeliveryAddressEntity> extends DefaultServiceImpl<T> implements ICmDeliveryAddressService<T> {
	/**
	 * 自动注入的数据访问对象
	 */
	@Autowired
	private ICmDeliveryAddressDao<T> cmDeliveryAddressDao;

    @Override
    protected Dao<T> getDao() {
        return cmDeliveryAddressDao;
    }

	@Override
	public CmDeliveryAddressEntity getByUserId(Integer userId) {
		return cmDeliveryAddressDao.getByUserId(userId);
	}
}