/**
 * Description: CmAssess业务实现类
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-12-29 上午 11:12:24
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-12-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.CmAssessEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICmAssessDao;
import com.house365.ws.service.interfaces.ICmAssessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmAssess业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-12-29
 * @see
 * @since 1.0
 */
@Service("cmAssessService")
public class CmAssessServiceImpl<T extends CmAssessEntity> extends DefaultServiceImpl<T> implements ICmAssessService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private ICmAssessDao<T> cmAssessDao;

    @Override
    protected Dao<T> getDao() {
        return cmAssessDao;
    }

    @Override
    public List<String> getClearIds() {
        return cmAssessDao.getClearIds();
    }

    @Override
    public Integer getMinIdByUserId(String userId) {
        return cmAssessDao.getMinIdByUserId(userId);
    }

    @Override
    public void removeWaste(String userId,Integer minId){
        cmAssessDao.removeWaste(userId,minId);
    }

}
