package com.house365.ws.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.house365.beans.po.BaseAttachment;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IAttachmentDao;
import com.house365.ws.service.interfaces.IAttachmentService;

@Service("attachmentService")
public class AttachmentServiceImpl<T extends BaseAttachment> extends DefaultServiceImpl<T> implements
		IAttachmentService<T> {

	@Autowired
	IAttachmentDao<T> attachmentDao;
	@Override
	protected Dao<T> getDao() {
		return attachmentDao;
	}
    public List<BaseAttachment> getByResourceId(Integer resourceId) {
        return attachmentDao.getByResourceId(resourceId);
    }
    /**
     * 根据resourceId和resouceType查询
     */
    public List<BaseAttachment> queryByResourceIdAndResouceType(String resourceId, String channel) {
        return attachmentDao.queryByResourceIdAndResouceType(resourceId, channel);
    }
    
	@Override
	public void deleteAttachment(Integer resourceId) {
		attachmentDao.deleteAttachment(resourceId);
	}
	
	@Override
	public void updateAttachmentResourceId(Integer resourceId) {
		attachmentDao.updateAttachmentResourceId(resourceId);
	}

}
