/*
 * Copyright (C), 2002-2015, 江苏三六五网络股份有限公司
 * FileName: HmcSmsCodeInterface.java
 * Author:   duhui
 * Date:     2015年5月8日 下午4:07:38
 * Description:     
 * History: 
 * <author>      <time>      <version>    <desc>
 * 修改人姓名                          修改时间                        版本号                                 描述
 */
package com.house365.ws.interfaces.rest;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.house365.beans.entity.CmSmsCodeEntity;
import com.house365.commons.system.SmsUtils;
import com.house365.rest.context.CmConstant;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.web.util.DateTimeUtils;
import com.house365.web.util.MemoryPropertyPlaceholderConfigurer;
import com.house365.ws.service.interfaces.ICmSmsCodeService;
import com.house365.ws.system.ReturnAppResult;

/**
 * 短信验证码接口
 *
 * @author nizhengjia
 * @version [v1.0.0, 2015年8月19日]
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
@Component("smsCodeInterface")
public class SmsCodeInterface implements ISmsCodeInterface {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(SmsCodeInterface.class);

    /**
     * 验证码有效时间（分钟）
     */
    @SuppressWarnings("unused")
    private static final int AUTH_CODE_TIME = 60;

    /**
     * 接口参数手机号码
     */
    private static final String PHONE = "phone";

    /**
     * 接口参数城市
     */
    private static final String CITY = "city";

    /**
     * 参数列表
     */
    private static final String[] PARAMS = {PHONE, CmConstant.CITY_KEY};

    /**
     * cmSmsCodeEntity服务对象
     */
    @Autowired
    private ICmSmsCodeService<CmSmsCodeEntity> cmSmsCodeService;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {

        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<String> response = new House365RestResponse<String>();

        // 业务校验统一入口
        try {
            checkInterfaceParameter(map);
        } catch (IllegalServiceParameterException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
            return JSONObject.fromObject(response).toString();
        }

        // 业务层统一处理
        try {
            House365RestObject<String> data = doBusiness(map);
            response.setData(data);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            response.setMsg("发送成功!");
        } catch (ServiceRunException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
        }

        return JSONObject.fromObject(response).toString();
    }

    /**
     * 业务层统校验自己所需参数是否存在
     *
     * @param map 请求参数封装成Map对象
     * @return 统一返回参数
     * @author duhui
     * @version [v1.0.0, 2015年5月8日]
     * @since [产品/模块版本](可选)
     */
    protected void checkInterfaceParameter(Map<String, Object> map) throws IllegalServiceParameterException {

        // 方法所需参数
        for (String str : PARAMS) {
            // 如果不存在跳出同时抛出相应异常
            if (!map.containsKey(str)) {
                LOGGER.error("业务入口参数异常：" + str + "参数为空!");
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }
        }

    }

    /**
     * 业务层统逻辑处理 返回验证码业务逻辑操作
     *
     * @param
     * @return 统一返回参数
     * @author duhui
     * @version [v1.0.0, 2015年5月8日]
     * @since [产品/模块版本](可选)
     */
    protected House365RestObject<String> doBusiness(Map<String, Object> map) throws ServiceRunException {
        try {
            // 发送短信城市通道
            String city = ((String[]) map.get(CmConstant.CITY_KEY))[0];
            // 发送手机号
            String phone = ((String[]) map.get(PHONE))[0];
            // 校验当日手机号码发送验证码次数
            validTodaySmsTimes(phone);
            // 生成六位短信验证码
            String authCode = getSmsCode(phone, city);
            // 根据短信模板生成的短信内容
            String smsInfo = getSmsTemplet(authCode);
            // 取得短信接口URL
            String smsUrl = MemoryPropertyPlaceholderConfigurer.getContextProperty("system.default.smsUrl");
            // 发送短信操作
            SmsUtils.sendSms(smsUrl, city, phone, smsInfo, authCode);
            // 封装返回对象
            House365RestObject<String> restObject = new House365RestObject<String>();
            List<String> list = new ArrayList<String>();
            //list.add(authCode);
            restObject.setTotal("1");
            restObject.setList(list);

            return restObject;
        } catch (Exception ex) {
            LOGGER.error("获取验证码接口异常！", ex);
            throw new ServiceRunException("获取验证码接口异常！" + ex.getMessage());
        }
    }

    /**
     * 取得验证码，并进行数据相关操作。 1、如果该手机号存在，则判定时间。 一小时内取值直接返回，超过一小时则重新生成验证码，并更新数据库记录。 2、如果不存在，则插入相应记录
     *
     * @return 验证码短信内容
     */
    private String getSmsCode(String phone, String city) {
        CmSmsCodeEntity cmSmsCodeEntity = cmSmsCodeService.getByPhone(phone);
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("phone", phone);
        // 生成六位随机验证码
        String authCode = (Math.random() * 900000 + 100000 + "").substring(0, 6);
        // 如果不存在，掺入相应记录，返回验证码。
        if (null == cmSmsCodeEntity) {
            cmSmsCodeEntity = new CmSmsCodeEntity();
            cmSmsCodeEntity.setPhone(phone);
            cmSmsCodeEntity.setAuthCode(authCode);
            cmSmsCodeEntity.setSendTime(new Date());
            cmSmsCodeEntity.setSmsCount(0);
            cmSmsCodeEntity.setTodayDate(new Date());
            cmSmsCodeEntity.setCreateTime(new Date());
            cmSmsCodeEntity.setCity(city);
            cmSmsCodeService.save(cmSmsCodeEntity);

            // 返回验证码
            return authCode;
        } else {
            // 如果该手机号存在，则重新生成验证码，并更新数据库记录。
            cmSmsCodeEntity.setAuthCode(authCode);
            cmSmsCodeEntity.setSendTime(new Date());
            cmSmsCodeEntity.setSmsCount(cmSmsCodeEntity.getSmsCount() + 1);
            cmSmsCodeService.update(cmSmsCodeEntity);
            return authCode;
        }
    }

    /**
     * 短信内容模板
     *
     * @return 验证码短信内容
     */
    private String getSmsTemplet(String smsCode) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("尊敬的365网友，您操作的验证码为");
        stringBuffer.append(smsCode);
        stringBuffer.append("，请在收到后5分钟内提交。");

        return stringBuffer.toString();
    }

    /**
     * 校验当日短信发送次数
     *
     * @return true or false
     * @throws ServiceRunException
     * @author nizhengjia
     */
    private void validTodaySmsTimes(String phone) throws ServiceRunException {
        Map<String, Object> allRecord = cmSmsCodeService.findAllSmsRecord(phone);
        Integer smsRecordCount = allRecord == null ? 0 : Integer.parseInt(allRecord.get("smscount").toString());
        // 短信发送时间
        String sendTime = allRecord == null ? "" : allRecord.get("sendTime").toString();
        // 当前系统时间
        String curServerTime = DateTimeUtils.getCurrentDateString();
        // 短信次数配置
        Integer curCount = Integer.parseInt(MemoryPropertyPlaceholderConfigurer.getContextProperty("sms.count"));
        // 比较时间和短信发送次数 如满足规则则提示
        if (smsRecordCount >= curCount && curServerTime.equals(sendTime)) {
            throw new ServiceRunException("短信验证码今日已超出限制");
        }
        if (!curServerTime.equals(sendTime)) {
            // 重置次数
            Map<String, Object> param = new HashMap<String, Object>();
            param.put("resetCount", "0");
            param.put("phone", phone);
            cmSmsCodeService.recordSmsTimes(param);
        }
    }

    /**
     * 判断服务是否具有控制逻辑
     *
     * @return 是否判断
     */
    @Override
    public boolean isControlService() {
        return false;
    }

    /**
     * 判断服务是否需要记录日志
     *
     * @return 是否判断
     */
    @Override
    public boolean isLogService() {
        return false;
    }

    /**
     * 判断服务是否需要监控
     *
     * @return 是否判断
     */
    @Override
    public boolean isMonitorService() {
        return false;
    }

    /**
     * 事务回滚
     *
     * @return 事务回滚预留结果，暂无用途
     */
    @Override
    public Object rollback() {
        return null;
    }

    /**
     * 事务提交
     */
    @Override
    public void commit() {
    }

}
