package com.house365.ws.interfaces.rest;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.google.common.base.Strings;
import com.house365.ws.cached.RedisUtilsInterface;
import com.house365.ws.util.CmCommonUtils;
import net.sf.json.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.house365.beans.entity.CmCreditRecordEntity;
import com.house365.beans.entity.CmInviteRecordEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.service.interfaces.ICmInviteRecordService;
import com.house365.ws.service.interfaces.ICmUserService;
import com.house365.ws.system.ReturnAppResult;
import com.house365.ws.util.Constant;
import com.house365.ws.util.InviteCodeUtil;

@Component("inviteUserInterface")
public class InviteUserInterfaceImpl implements ICmInviteUserInterface {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(InviteUserInterfaceImpl.class);

    @Autowired
    ICmInviteRecordService<CmInviteRecordEntity> cmInviteRecordService;
    @Autowired
    ICmUserService<CmUserEntity> cmUserService;

    static final String lockKey = "invite:lock";

    @Autowired
    RedisUtilsInterface redisUtils;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<Map<String, Object>> response = new House365RestResponse<>();
        // 业务校验统一入口
        try {
            CmCommonUtils.checkInterfaceParameter(Constant.InviteUserParams, map);
        } catch (IllegalServiceParameterException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
            return JSONObject.fromObject(response).toString();
        }
        House365RestObject<Map<String, Object>> data = null;
        // 业务层统一处理
        try {

            //一次只能处理一个订单,本地一次订单入库大概需要90ms,如有超卖问题，可适当调整持有锁的时间
            while (true) {
                long time = System.currentTimeMillis() + 30;
                boolean isNotLock = redisUtils.setNotExists(lockKey, time + "");
                if (isNotLock || (redisUtils.getValByKeyNew(
                    lockKey) != null && System.currentTimeMillis() > Long.parseLong(
                    redisUtils.getValByKeyNew(lockKey)) && System.currentTimeMillis() > Long.parseLong(
                    redisUtils.getSet(lockKey, time + "")))) {
                    LOGGER.debug("===== Get LOCK ");
                    break;
                } else {
                    Thread.sleep(35);
                }
            }

            long start = System.currentTimeMillis();


            CmUserEntity cmUser = cmUserService.registUserByUserId(map);
            if (cmUser == null) {
                throw new ServiceRunException("被邀请人不存在!");
            }

            data = doBusiness(map, cmUser);
            if (StringUtils.isEmpty(data.getTotal())) {
                response.setData(null);
                response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
                response.setMsg("操作失败");
            } else {
                response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
                if (data.getEntity() != null && data.getEntity().get("inviterCredit") != null) {
                    response.setMsg("提交成功，好友将会获得" + data.getEntity().get("inviterCredit") + "淘房币");
                } else {
                    response.setMsg("操作成功");
                }
            }

        } catch (Exception e) {
            LOGGER.error(e.getMessage());
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
        } finally {
            //移除订单提交标记
            LOGGER.debug("===== 移除订单提交标记!");
            redisUtils.deleteKey(lockKey);
        }

        JSONObject jsonObject = JSONObject.fromObject(response);
        if (data != null) {
            jsonObject.put("data", data.getEntity());
        }
        return jsonObject.toString();
    }

    /**
     * 业务层统校验自己所需参数是否存在
     *
     * @param map 请求参数封装成Map对象
     * @return 统一返回参数
     * @author yinchangming
     * @version [v1.0.0, 2015年8月18日]
     * @since [产品/模块版本](可选)
     */


    /**
     * 业务层统逻辑处理
     *
     * @param
     * @return 统一返回参数
     * @throws ServiceRunException
     * @author yangyang
     * @version [v1.0.0, 2015年7月1日]
     * @since [产品/模块版本](可选)
     */
    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    public House365RestObject<Map<String, Object>> doBusiness(Map<String, Object> map, CmUserEntity cmUser) throws Exception {
        // 返回Json对象
        House365RestObject<Map<String, Object>> restObject = new House365RestObject<>();
        try {
            //被邀请用户已经被邀请过
            Integer inviteCodeDb = cmUser.getInviteCode();
            if (inviteCodeDb != null && inviteCodeDb != 0) {
                LOGGER.error("用户已被邀请！");
                throw new ServiceRunException("你已经被邀请过了哦！");
            }

            Integer inviteCodeInt = null;
            String inviteCode = null;
            //邀请人
            try {
                inviteCode = ((String[]) map.get(Constant.INVITED_CODE))[0];
                inviteCodeInt = Integer.parseInt(inviteCode);
            } catch (Exception e) {
                throw new ServiceRunException("邀请码不正确！");
            }

            //邀请成功保存设备号，下次判断此设备号是否存在邀请记录，如存在则不允许操作
            String deviceId = String.valueOf(map.containsKey("deviceId") ? map.get("deviceId") : "");

            if (!Strings.isNullOrEmpty(deviceId)) {
                Integer deviceInvite = cmUserService.countDeviceInvite(deviceId);
                if (deviceInvite.intValue() > 0) {
                    LOGGER.error("此设备号用户[{}]已被邀请！", deviceId);
                    throw new ServiceRunException("该设备已被邀请过，请更换其他新设备！");
                }
            }else{
                throw new ServiceRunException("网络不稳定，请稍后重试！");
            }

            //邀请人ID
            Integer inviterId = InviteCodeUtil.getUserIdByInviteCode(inviteCodeInt);
            //获取邀请人
            CmUserEntity cmInviter = cmUserService.getById(inviterId);
            if (cmInviter == null) {
                throw new ServiceRunException("邀请码不正确!");
            }
            if (cmInviter.getUserId().equals(cmUser.getUserId())) {
                throw new ServiceRunException("不能提交自己的邀请码!");
            }
            map.put("currentInviterUser", cmInviter);

            //被邀请人未被邀请过
            CmInviteRecordEntity entity = new CmInviteRecordEntity();
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            entity.setInvitedCode(inviteCode);
            entity.setInvitedUser(cmUser.getId());
            entity.setInviter(inviterId);
            Integer recordId = cmInviteRecordService.save(entity);
            map.put("recordId", recordId);
            //更新邀请人信息
            if (cmInviter.getInviteCount() == null) {
                cmInviter.setInviteCount(0);
            }
            if (cmInviter.getInviteCredits() == null) {
                cmInviter.setInviteCredits(0);
            }
            //给予邀请人奖励，返回成功提示
            CmCreditRecordEntity creditRecord = cmInviteRecordService.transInviteUser(map);
            //更新被邀请人
            cmUser.setInviteCode(inviteCodeInt);
            cmUser.setInviter(inviterId);
            if (!Strings.isNullOrEmpty(deviceId)) {
                cmUser.setDeviceid(deviceId);
            }

            //对用户表积分余额进行操作
            cmInviter.setCredits(creditRecord.getRemainingAmount());
            if (cmInviter.getInviteCount() == null) {
                cmInviter.setInviteCount(0);
            }
            cmInviter.setInviteCount(cmInviter.getInviteCount() + 1);
            cmInviter.setInviteCredits(cmInviter.getInviteCredits() + creditRecord.getAmount());
            cmUserService.update(cmInviter);
            //更新被邀请用户
            cmUserService.update(cmUser);
            //cmInviter.setInviteCount(cmInviter.getInviteCount()+1);
            //cmInviter.setInviteCredits(cmInviter.getInviteCredits()+creditRecord.getAmount());
            // cmUserService.update(cmInviter);
            restObject.setTotal("0");
            Map<String, Object> data = new HashMap<>();
            data.put("inviter", String.valueOf(inviterId));
            data.put("inviterCode", inviteCode);
            data.put("inviterCredit", String.valueOf(creditRecord.getAmount()));
            restObject.setEntity(data);
            return restObject;
        } catch (Exception ex) {
            LOGGER.error("邀请用户异常(Get HMConsultant Error)！", ex);
            if (ex instanceof ServiceRunException) {
                throw ex;
            } else {
                throw new ServiceRunException("网络不给力，请刷新重试");
            }

        }
    }

    @Override
    public boolean isControlService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isLogService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public boolean isMonitorService() {
        // TODO Auto-generated method stub
        return false;
    }

    @Override
    public Object rollback() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void commit() {
        // TODO Auto-generated method stub

    }

}
