package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.CmUserEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.web.util.StringUtils;
import com.house365.ws.dao.mapper.CmUserMapper;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Created by Administrator on 2019/10/12.
 */
@Component("getUserCountByTime")
public class GetInviteUserByTimeImpl implements IGetInviteUserByTime {

    private static final Logger logger = LoggerFactory.getLogger("GetInviteUserByTimeImpl");
    private static final String RESULT = "result";
    private static final String MSG = "msg";

    @Autowired
    private CmUserMapper userMapper;

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        Map<String, Object> resultMap = new HashMap<>(10);
        // 业务层统一处理
        try {
            if (!map.containsKey("inviteCode") || map.get("inviteCode") == null) {
                resultMap.put(RESULT, ReturnAppResult.APP_FAIL.getResultCode());
                resultMap.put(MSG, "邀请码不能为空!");
                return JSONObject.fromObject(resultMap).toString();
            }
            String inviteCode = ((String[]) map.get("inviteCode"))[0];
            if (!map.containsKey("startTime") || map.get("startTime") == null) {
                resultMap.put(RESULT, ReturnAppResult.APP_FAIL.getResultCode());
                resultMap.put(MSG, "开始时间不能为空!");
                return JSONObject.fromObject(resultMap).toString();
            }

            String startTime = ((String[]) map.get("startTime"))[0];
            if (Strings.isNullOrEmpty(startTime) || !StringUtils.isNumeric(startTime)) {
                resultMap.put(RESULT, ReturnAppResult.APP_FAIL.getResultCode());
                resultMap.put(MSG, "开始时间必须是数字!");
                return JSONObject.fromObject(resultMap).toString();
            }

            if (!map.containsKey("endTime") || map.get("endTime") == null) {
                resultMap.put(RESULT, ReturnAppResult.APP_FAIL.getResultCode());
                resultMap.put(MSG, "截止时间不能为空!");
                return JSONObject.fromObject(resultMap).toString();
            }

            String endTime = ((String[]) map.get("endTime"))[0];
            if (Strings.isNullOrEmpty(endTime) || !StringUtils.isNumeric(endTime)) {
                resultMap.put(RESULT, ReturnAppResult.APP_FAIL.getResultCode());
                resultMap.put(MSG, "截止时间必须是数字!");
                return JSONObject.fromObject(resultMap).toString();
            }

            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String star = format.format(Long.parseLong(startTime));
            String end = format.format(Long.parseLong(endTime));

            Map<String, Object> searchMap = new HashMap<>(10);
            searchMap.put("inviteCode", inviteCode);
            searchMap.put("startTime", star);
            searchMap.put("endTime", end);
            List<CmUserEntity> list = userMapper.queryByConditions(searchMap);
            if (CollectionUtils.isNotEmpty(list)) {
                resultMap.put("count", list.size());
                resultMap.put("phone", list.get(0).getPhoneNumber());
            } else {
                resultMap.put("count", 0);
                resultMap.put("phone", "");
            }
            resultMap.put("result", ReturnAppResult.APP_SUCCESS.getResultCode());
            resultMap.put("inviteCode", inviteCode);

            resultMap.put("startTime", startTime);
            resultMap.put("endTime", endTime);
            resultMap.put(MSG, "操作成功!");

        } catch (Exception e) {
            logger.error("根据时间获取用户信息失败", e);
            resultMap.put("result", ReturnAppResult.APP_FAIL.getResultCode());
            resultMap.put(MSG, "根据时间获取用户信息失败!");
        }

        return JSONObject.fromObject(resultMap).toString();
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public void commit() {

    }

}
