/*
 * Copyright (C), 2002-2015, 江苏三六五网络股份有限公司
 * FileName: ExchangeUserLoginInterfaceImpl.java
 * Author:   Administrator
 * Date:     2015年5月5日 下午2:57:41
 * Description: //模块目的、功能描述      
 * History: //修改记录
 * <author>      <time>      <version>    <desc>
 * 修改人姓名             修改时间            版本号                  描述
 */
package com.house365.ws.interfaces.rest;

import java.util.Map;

import net.sf.json.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import com.house365.beans.entity.CmCommentReportEntity;
import com.house365.rest.context.CmConstant;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.service.interfaces.ICmCommentReportService;
import com.house365.ws.system.ReturnAppResult;

/**
 * 〈一句话功能简述〉<br>
 * 〈功能详细描述〉
 *
 * @author Administrator
 * @version [版本号, 2015年5月5日]
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
@Component("commentReportInterface")
public class CommentReportInterfaceImpl implements ICommentReportInterface {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CommentReportInterfaceImpl.class);
    
    @Autowired
    private ICmCommentReportService<CmCommentReportEntity> commentReportService;
    
    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<CmCommentReportEntity> response = new House365RestResponse<>();
        // 业务校验统一入口
        try {
            checkInterfaceParameter(map);
        } catch (IllegalServiceParameterException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
            return JSONObject.fromObject(response).toString();
        }
        // 业务层统一处理
        try {
            House365RestObject<CmCommentReportEntity> data = doBusiness(map);
            response.setData(data);
            if (StringUtils.isEmpty(data.getTotal())) {
                response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
                response.setMsg("操作失败");
            } 
            else if("0".equals(data.getTotal())){
                response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
                response.setMsg("接口调用异常或该用户不存在");
            }
            else if("1".equals(data.getTotal())){
                response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
                response.setMsg("操作成功");
            }else if("2".equals(data.getTotal())){
                response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
                response.setMsg("评论ID有误，评论不存在");
            }

        } catch (ServiceRunException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
        }

        return JSONObject.fromObject(response).toString();
    }

    /**
     * 
     * 业务层统校验自己所需参数是否存在
     *
     * @author yangyang
     * @version [v1.0.0, 2015年8月18日]
     * @param map 请求参数封装成Map对象
     * @return 统一返回参数
     * @since [产品/模块版本](可选)
     */
    protected void checkInterfaceParameter(Map<String, Object> map) throws IllegalServiceParameterException {

        // 方法所需参数
        for (String str : CmConstant.CommentReport) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                LOGGER.error("业务入口参数异常：" + str + "参数为空!");
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }

        }
    }

    /**
     * 
     * 业务层统逻辑处理
     *
     * @author yangyang
     * @version [v1.0.0, 2015年7月1日]
     * @param   map
     * @return 统一返回参数
     * @throws ServiceRunException
     * @since [产品/模块版本](可选)
     */
    protected House365RestObject<CmCommentReportEntity> doBusiness(Map<String, Object> map) throws ServiceRunException {
        // 返回Json对象
        House365RestObject<CmCommentReportEntity> restObject = new House365RestObject<CmCommentReportEntity>();
        
        try{
            String result = commentReportService.transCommentReport(map);
        
        	restObject.setTotal(result);
            return restObject;
        } catch (Exception ex) {
        	ex.printStackTrace();
            LOGGER.error("积分商城-评论举报数据异常！");
            throw new ServiceRunException("网络不给力，请刷新重试");
        }
    }


    /**
     * 判断服务是否具有控制逻辑
     * 
     * @return 是否判断
     */
    @Override
    public boolean isControlService() {
        return false;
    }

    /**
     * 判断服务是否需要记录日志
     * 
     * @return 是否判断
     */
    @Override
    public boolean isLogService() {
        return false;
    }

    /**
     * 判断服务是否需要监控
     * 
     * @return 是否判断
     */
    @Override
    public boolean isMonitorService() {
        return false;
    }

    /**
     * 事务回滚
     * 
     * @return 事务回滚预留结果，暂无用途
     */
    @Override
    public Object rollback() {
        return null;
    }

    /**
     * 事务提交
     */
    @Override
    public void commit() {
    }
}
