package com.house365.ws.interfaces.rest;

import com.house365.beans.entity.CmCreditRecordEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.service.interfaces.ICmCreditRecordService;
import com.house365.ws.service.interfaces.ICmUserService;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Date: 16/8/26</p>
 *
 * @author XN
 * @version 1.0
 */
@Component("changeCredits")
public class ChangeCreditImpl implements IChangeCredit {
    private static final Logger LOGGER = LoggerFactory.getLogger("InterfaceLog");

    @Autowired
    ICmCreditRecordService<CmCreditRecordEntity> icmCreditRecordService;

    @Autowired
    ICmUserService<CmUserEntity> iCmUserService;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        Map<String, Object> resultMap = new HashMap<>();
        // 业务层统一处理
        try {
            Integer credit = Integer.valueOf(((String[]) map.get("amount"))[0]);
            Integer rule = Integer.valueOf(((String[]) map.get("rule"))[0]);

            CmUserEntity cmUser = iCmUserService.registUserByUserId(map);
            if (cmUser == null) {
                throw new ServiceRunException("用户中心用户不存在!");
            }

            Map<String, Object> searchMap = new HashMap<>();
            searchMap.put("EQ_userId", cmUser.getId());
            searchMap.put("EQ_ruleId", rule);

            QueryParams queryParams = new QueryParams();
            queryParams.setSearchParams(searchMap);
            int creditRecordEntities = icmCreditRecordService.getTotalCount(queryParams);
            // 修改积分接口提供给PHP应用使用，规则20积分变动应在业务端有对应记录。手动操作应有产品通知依据。
            if (rule.intValue() != 20 && rule.intValue() != 9 && creditRecordEntities > 0) {
                throw new ServiceRunException("用户已参加过活动!");
            }

            iCmUserService.transChangeUserCredit(cmUser, rule, credit);

            Map<String, Object> dataMap = new HashMap<>();
            dataMap.put("amount", credit);
            dataMap.put("totalCredit", cmUser.getCredits());
            dataMap.put("userId", cmUser.getUserId());
            resultMap.put("data", dataMap);
            resultMap.put("result", ReturnAppResult.APP_SUCCESS.getResultCode());
            resultMap.put("msg", "获取成功！");
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            resultMap.put("result", ReturnAppResult.APP_FAIL.getResultCode());
            resultMap.put("msg", e.getMessage());
        }
        return JSONObject.fromObject(resultMap).toString();
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }
}
