/**
 * Description: KlfCityWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-07-10 上午 10:47:22
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-07-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.KlfCityEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.KlfCityListRequest;
import com.house365.ws.beans.request.KlfCityRequest;
import com.house365.ws.beans.response.KlfCityListResponse;
import com.house365.ws.beans.response.KlfCityResponse;
import com.house365.ws.interfaces.server.IKlfCity;
import com.house365.ws.service.interfaces.IKlfCityService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * KlfCityWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-07-10
 * @see
 * @since 1.0
 */
@Service("klfCity")
public class KlfCityImpl implements IKlfCity {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(KlfCityImpl.class);

    /**
     * KlfCity服务对象
     */
    @Autowired
    private IKlfCityService<KlfCityEntity> klfCityService;

    /**
     * KlfCity列表查询
     *
     * @param request KlfCity列表查询请求
     * @return KlfCity列表查询响应
     */
    @Override
    public KlfCityListResponse getKlfCityList(KlfCityListRequest request) {
        KlfCityListResponse response = new KlfCityListResponse();
        try {
            QueryParams<KlfCityEntity> queryParams = new QueryParams<KlfCityEntity>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<KlfCityEntity> klfCitys = klfCityService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(klfCitys);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存KlfCity
     *
     * @param request KlfCity请求
     * @return 保存KlfCity响应
     */
    @Override
    public KlfCityResponse addKlfCity(KlfCityRequest request) {
        KlfCityResponse response = new KlfCityResponse();
        try {
            KlfCityEntity entity = request.getEntity();
            klfCityService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除KlfCity通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除KlfCity响应
     */
    @Override
    public KlfCityResponse deleteKlfCityById(Integer id) {
        KlfCityResponse response = new KlfCityResponse();
        try {
            klfCityService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改KlfCity
     *
     * @param request 修改KlfCity请求
     * @return 修改KlfCity响应
     */
    public KlfCityResponse updateKlfCity(KlfCityRequest request) {
        KlfCityResponse response = new KlfCityResponse();
        try {
            klfCityService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取KlfCity
     *
     * @param id 唯一标识
     * @return 通过ID获取KlfCity响应
     */
    @Override
    public KlfCityResponse getKlfCityById(Integer id) {
        KlfCityResponse response = new KlfCityResponse();
        try {
            KlfCityEntity entity = klfCityService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
