/**
 * Description: CmSeckillRemindWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-11-29 下午 14:08:45
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-11-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmSeckillRemindEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmSeckillRemindListRequest;
import com.house365.ws.beans.request.CmSeckillRemindRequest;
import com.house365.ws.beans.response.CmSeckillRemindListResponse;
import com.house365.ws.beans.response.CmSeckillRemindResponse;
import com.house365.ws.interfaces.server.ICmSeckillRemind;
import com.house365.ws.service.interfaces.ICmSeckillRemindService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmSeckillRemindWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-11-29
 * @see
 * @since 1.0
 */
@Service("cmSeckillRemind")
public class CmSeckillRemindImpl implements ICmSeckillRemind {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmSeckillRemindImpl.class);

    /**
     * CmSeckillRemind服务对象
     */
    @Autowired
    private ICmSeckillRemindService<CmSeckillRemindEntity> cmSeckillRemindService;

    /**
     * CmSeckillRemind列表查询
     *
     * @param request CmSeckillRemind列表查询请求
     * @return CmSeckillRemind列表查询响应
     */
    @Override
    public CmSeckillRemindListResponse getCmSeckillRemindList(CmSeckillRemindListRequest request) {
        CmSeckillRemindListResponse response = new CmSeckillRemindListResponse();
        try {
            QueryParams<CmSeckillRemindEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CmSeckillRemindEntity> cmSeckillReminds = cmSeckillRemindService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmSeckillReminds);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmSeckillRemind
     *
     * @param request CmSeckillRemind请求
     * @return 保存CmSeckillRemind响应
     */
    @Override
    public CmSeckillRemindResponse addCmSeckillRemind(CmSeckillRemindRequest request) {
        CmSeckillRemindResponse response = new CmSeckillRemindResponse();
        try {
            CmSeckillRemindEntity entity = request.getEntity();
            cmSeckillRemindService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmSeckillRemind通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmSeckillRemind响应
     */
    @Override
    public CmSeckillRemindResponse deleteCmSeckillRemindById(Integer id) {
        CmSeckillRemindResponse response = new CmSeckillRemindResponse();
        try {
            cmSeckillRemindService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmSeckillRemind
     *
     * @param request 修改CmSeckillRemind请求
     * @return 修改CmSeckillRemind响应
     */
    @Override
    public CmSeckillRemindResponse updateCmSeckillRemind(CmSeckillRemindRequest request) {
        CmSeckillRemindResponse response = new CmSeckillRemindResponse();
        try {
            cmSeckillRemindService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmSeckillRemind
     *
     * @param id 唯一标识
     * @return 通过ID获取CmSeckillRemind响应
     */
    @Override
    public CmSeckillRemindResponse getCmSeckillRemindById(Integer id) {
        CmSeckillRemindResponse response = new CmSeckillRemindResponse();
        try {
            CmSeckillRemindEntity entity = cmSeckillRemindService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
