/**
 * Description: CmSeckillBookedWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-11-29 下午 14:08:43
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-11-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmSeckillBookedEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmSeckillBookedListRequest;
import com.house365.ws.beans.request.CmSeckillBookedRequest;
import com.house365.ws.beans.response.CmSeckillBookedListResponse;
import com.house365.ws.beans.response.CmSeckillBookedResponse;
import com.house365.ws.interfaces.server.ICmSeckillBooked;
import com.house365.ws.service.interfaces.ICmSeckillBookedService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmSeckillBookedWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-11-29
 * @see
 * @since 1.0
 */
@Service("cmSeckillBooked")
public class CmSeckillBookedImpl implements ICmSeckillBooked {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmSeckillBookedImpl.class);

    /**
     * CmSeckillBooked服务对象
     */
    @Autowired
    private ICmSeckillBookedService<CmSeckillBookedEntity> cmSeckillBookedService;

    /**
     * CmSeckillBooked列表查询
     *
     * @param request CmSeckillBooked列表查询请求
     * @return CmSeckillBooked列表查询响应
     */
    @Override
    public CmSeckillBookedListResponse getCmSeckillBookedList(CmSeckillBookedListRequest request) {
        CmSeckillBookedListResponse response = new CmSeckillBookedListResponse();
        try {
            QueryParams<CmSeckillBookedEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CmSeckillBookedEntity> cmSeckillBookeds = cmSeckillBookedService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmSeckillBookeds);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmSeckillBooked
     *
     * @param request CmSeckillBooked请求
     * @return 保存CmSeckillBooked响应
     */
    @Override
    public CmSeckillBookedResponse addCmSeckillBooked(CmSeckillBookedRequest request) {
        CmSeckillBookedResponse response = new CmSeckillBookedResponse();
        try {
            CmSeckillBookedEntity entity = request.getEntity();
            cmSeckillBookedService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmSeckillBooked通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmSeckillBooked响应
     */
    @Override
    public CmSeckillBookedResponse deleteCmSeckillBookedById(Integer id) {
        CmSeckillBookedResponse response = new CmSeckillBookedResponse();
        try {
            cmSeckillBookedService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmSeckillBooked
     *
     * @param request 修改CmSeckillBooked请求
     * @return 修改CmSeckillBooked响应
     */
    @Override
    public CmSeckillBookedResponse updateCmSeckillBooked(CmSeckillBookedRequest request) {
        CmSeckillBookedResponse response = new CmSeckillBookedResponse();
        try {
            cmSeckillBookedService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmSeckillBooked
     *
     * @param id 唯一标识
     * @return 通过ID获取CmSeckillBooked响应
     */
    @Override
    public CmSeckillBookedResponse getCmSeckillBookedById(Integer id) {
        CmSeckillBookedResponse response = new CmSeckillBookedResponse();
        try {
            CmSeckillBookedEntity entity = cmSeckillBookedService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    @Override
    public void deleteCmSeckillBookedByGoodId(Integer id) {
        cmSeckillBookedService.deleteCmSeckillBookedByGoodId(id);
    }

    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
