/**
 * Description: CmReplyPraiseWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-11 上午 09:31:52
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-11   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmReplyPraiseEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmReplyPraiseListRequest;
import com.house365.ws.beans.request.CmReplyPraiseRequest;
import com.house365.ws.beans.response.CmReplyPraiseListResponse;
import com.house365.ws.beans.response.CmReplyPraiseResponse;
import com.house365.ws.interfaces.server.ICmReplyPraise;
import com.house365.ws.service.interfaces.ICmReplyPraiseService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmReplyPraiseWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-11
 * @see
 * @since 1.0
 */
@Service("cmReplyPraise")
public class CmReplyPraiseImpl implements ICmReplyPraise {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmReplyPraiseImpl.class);

    /**
     * CmReplyPraise服务对象
     */
    @Autowired
    private ICmReplyPraiseService<CmReplyPraiseEntity> cmReplyPraiseService;

    /**
     * CmReplyPraise列表查询
     *
     * @param request CmReplyPraise列表查询请求
     * @return CmReplyPraise列表查询响应
     */
    @Override
    public CmReplyPraiseListResponse getCmReplyPraiseList(CmReplyPraiseListRequest request) {
        CmReplyPraiseListResponse response = new CmReplyPraiseListResponse();
        try {
            QueryParams<CmReplyPraiseEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmReplyPraiseEntity> cmReplyPraises = cmReplyPraiseService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmReplyPraises);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmReplyPraise
     *
     * @param request CmReplyPraise请求
     * @return 保存CmReplyPraise响应
     */
    @Override
    public CmReplyPraiseResponse addCmReplyPraise(CmReplyPraiseRequest request) {
        CmReplyPraiseResponse response = new CmReplyPraiseResponse();
        try {
            CmReplyPraiseEntity entity = request.getEntity();
            cmReplyPraiseService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmReplyPraise通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmReplyPraise响应
     */
    @Override
    public CmReplyPraiseResponse deleteCmReplyPraiseById(Integer id) {
        CmReplyPraiseResponse response = new CmReplyPraiseResponse();
        try {
            cmReplyPraiseService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmReplyPraise
     *
     * @param request 修改CmReplyPraise请求
     * @return 修改CmReplyPraise响应
     */
    @Override
    public CmReplyPraiseResponse updateCmReplyPraise(CmReplyPraiseRequest request) {
        CmReplyPraiseResponse response = new CmReplyPraiseResponse();
        try {
            cmReplyPraiseService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmReplyPraise
     *
     * @param id 唯一标识
     * @return 通过ID获取CmReplyPraise响应
     */
    @Override
    public CmReplyPraiseResponse getCmReplyPraiseById(Integer id) {
        CmReplyPraiseResponse response = new CmReplyPraiseResponse();
        try {
            CmReplyPraiseEntity entity = cmReplyPraiseService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
