/**
 * Description: 商品促销关联WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-01 上午 10:52:46
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-01   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmPromotionProductEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmPromotionProductListRequest;
import com.house365.ws.beans.request.CmPromotionProductRequest;
import com.house365.ws.beans.response.CmPromotionProductListResponse;
import com.house365.ws.beans.response.CmPromotionProductResponse;
import com.house365.ws.interfaces.server.ICmPromotionProduct;
import com.house365.ws.service.interfaces.ICmPromotionProductService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 商品促销关联WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-01
 * @see
 * @since 1.0
 */
@Service("cmPromotionProduct")
public class CmPromotionProductImpl implements ICmPromotionProduct {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmPromotionProductImpl.class);

    /**
     * 商品促销关联服务对象
     */
    @Autowired
    private ICmPromotionProductService<CmPromotionProductEntity> cmPromotionProductService;

    /**
     * 商品促销关联列表查询
     *
     * @param request 商品促销关联列表查询请求
     * @return 商品促销关联列表查询响应
     */
    @Override
    public CmPromotionProductListResponse getCmPromotionProductList(CmPromotionProductListRequest request) {
        CmPromotionProductListResponse response = new CmPromotionProductListResponse();
        try {
            QueryParams<CmPromotionProductEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CmPromotionProductEntity> cmPromotionProducts = cmPromotionProductService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmPromotionProducts);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存商品促销关联
     *
     * @param request 商品促销关联请求
     * @return 保存商品促销关联响应
     */
    @Override
    public CmPromotionProductResponse addCmPromotionProduct(CmPromotionProductRequest request) {
        CmPromotionProductResponse response = new CmPromotionProductResponse();
        try {
            CmPromotionProductEntity entity = request.getEntity();
            cmPromotionProductService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除商品促销关联通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除商品促销关联响应
     */
    @Override
    public CmPromotionProductResponse deleteCmPromotionProductById(Integer id) {
        CmPromotionProductResponse response = new CmPromotionProductResponse();
        try {
            cmPromotionProductService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改商品促销关联
     *
     * @param request 修改商品促销关联请求
     * @return 修改商品促销关联响应
     */
    @Override
    public CmPromotionProductResponse updateCmPromotionProduct(CmPromotionProductRequest request) {
        CmPromotionProductResponse response = new CmPromotionProductResponse();
        try {
            cmPromotionProductService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取商品促销关联
     *
     * @param id 唯一标识
     * @return 通过ID获取商品促销关联响应
     */
    @Override
    public CmPromotionProductResponse getCmPromotionProductById(Integer id) {
        CmPromotionProductResponse response = new CmPromotionProductResponse();
        try {
            CmPromotionProductEntity entity = cmPromotionProductService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public void updateStatus(List<String> productIds, int status) {
        cmPromotionProductService.updateStatus(productIds, status);
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
