/**
 * Description: CmOrderWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:17
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmOrderEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmOrderListRequest;
import com.house365.ws.beans.request.CmOrderRequest;
import com.house365.ws.beans.response.CmOrderListResponse;
import com.house365.ws.beans.response.CmOrderResponse;
import com.house365.ws.interfaces.server.ICmOrder;
import com.house365.ws.service.interfaces.ICmOrderService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmOrderWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmOrder")
public class CmOrderImpl implements ICmOrder {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmOrderImpl.class);

    /**
     * CmOrder服务对象
     */
    @Autowired
    private ICmOrderService<CmOrderEntity> cmOrderService;

    @Override
    public CmOrderListResponse getCmOrderStatisticsList(CmOrderListRequest request) {
        CmOrderListResponse response = new CmOrderListResponse();
        try {
            QueryParams<CmOrderEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CmOrderEntity> cmOrders = cmOrderService.getCmOrderStatisticsList(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmOrders);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * CmOrder列表查询
     *
     * @param request CmOrder列表查询请求
     * @return CmOrder列表查询响应
     */
    @Override
    public CmOrderListResponse getCmOrderList(CmOrderListRequest request) {
        CmOrderListResponse response = new CmOrderListResponse();
        try {
            QueryParams<CmOrderEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CmOrderEntity> cmOrders = cmOrderService.queryByPage(queryParams);

            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmOrders);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmOrder
     *
     * @param request CmOrder请求
     * @return 保存CmOrder响应
     */
    @Override
    public CmOrderResponse addCmOrder(CmOrderRequest request) {
        CmOrderResponse response = new CmOrderResponse();
        try {
            CmOrderEntity entity = request.getEntity();
            cmOrderService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmOrder通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmOrder响应
     */
    @Override
    public CmOrderResponse deleteCmOrderById(Integer id) {
        CmOrderResponse response = new CmOrderResponse();
        try {
            cmOrderService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmOrder
     *
     * @param request 修改CmOrder请求
     * @return 修改CmOrder响应
     */
    @Override
    public CmOrderResponse updateCmOrder(CmOrderRequest request) {
        CmOrderResponse response = new CmOrderResponse();
        try {
            cmOrderService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmOrder
     *
     * @param id 唯一标识
     * @return 通过ID获取CmOrder响应
     */
    @Override
    public CmOrderResponse getCmOrderById(Integer id) {
        CmOrderResponse response = new CmOrderResponse();
        try {
            CmOrderEntity entity = cmOrderService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
