/**
 * Description: CmExchangeCodeBatchWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-11-03 下午 17:36:18
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-11-03   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmExchangeCodeBatchEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmExchangeCodeBatchListRequest;
import com.house365.ws.beans.request.CmExchangeCodeBatchRequest;
import com.house365.ws.beans.response.CmExchangeCodeBatchListResponse;
import com.house365.ws.beans.response.CmExchangeCodeBatchResponse;
import com.house365.ws.interfaces.server.ICmExchangeCodeBatch;
import com.house365.ws.service.interfaces.ICmExchangeCodeBatchService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmExchangeCodeBatchWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-11-03
 * @see
 * @since 1.0
 */
@Service("cmExchangeCodeBatch")
public class CmExchangeCodeBatchImpl implements ICmExchangeCodeBatch {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmExchangeCodeBatchImpl.class);

    /**
     * CmExchangeCodeBatch服务对象
     */
    @Autowired
    private ICmExchangeCodeBatchService<CmExchangeCodeBatchEntity> cmExchangeCodeBatchService;

    /**
     * CmExchangeCodeBatch列表查询
     *
     * @param request
     *            CmExchangeCodeBatch列表查询请求
     * @return CmExchangeCodeBatch列表查询响应
     */
    @Override
    public CmExchangeCodeBatchListResponse getCmExchangeCodeBatchList(CmExchangeCodeBatchListRequest request) {
        CmExchangeCodeBatchListResponse response = new CmExchangeCodeBatchListResponse();
        try {
            QueryParams<CmExchangeCodeBatchEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            List<CmExchangeCodeBatchEntity> cmExchangeCodeBatchs = cmExchangeCodeBatchService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmExchangeCodeBatchs);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmExchangeCodeBatch
     *
     * @param request
     *            CmExchangeCodeBatch请求
     * @return 保存CmExchangeCodeBatch响应
     */
    @Override
    public CmExchangeCodeBatchResponse addCmExchangeCodeBatch(CmExchangeCodeBatchRequest request) {
        CmExchangeCodeBatchResponse response = new CmExchangeCodeBatchResponse();
        try {
            CmExchangeCodeBatchEntity entity = request.getEntity();
            cmExchangeCodeBatchService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmExchangeCodeBatch通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除CmExchangeCodeBatch响应
     */
    @Override
    public CmExchangeCodeBatchResponse deleteCmExchangeCodeBatchById(Integer id) {
        CmExchangeCodeBatchResponse response = new CmExchangeCodeBatchResponse();
        try {
            cmExchangeCodeBatchService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmExchangeCodeBatch
     *
     * @param request
     *            修改CmExchangeCodeBatch请求
     * @return 修改CmExchangeCodeBatch响应
     */
    @Override
    public CmExchangeCodeBatchResponse updateCmExchangeCodeBatch(CmExchangeCodeBatchRequest request) {
        CmExchangeCodeBatchResponse response = new CmExchangeCodeBatchResponse();
        try {
            cmExchangeCodeBatchService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmExchangeCodeBatch
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取CmExchangeCodeBatch响应
     */
    @Override
    public CmExchangeCodeBatchResponse getCmExchangeCodeBatchById(Integer id) {
        CmExchangeCodeBatchResponse response = new CmExchangeCodeBatchResponse();
        try {
            CmExchangeCodeBatchEntity entity = cmExchangeCodeBatchService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
