/**
 * Description: CmCreditRuleWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:11
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmCreditRuleEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmCreditRuleListRequest;
import com.house365.ws.beans.request.CmCreditRuleRequest;
import com.house365.ws.beans.response.CmCreditRuleListResponse;
import com.house365.ws.beans.response.CmCreditRuleResponse;
import com.house365.ws.interfaces.server.ICmCreditRule;
import com.house365.ws.service.interfaces.ICmCreditRuleService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmCreditRuleWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmCreditRule")
public class CmCreditRuleImpl implements ICmCreditRule {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmCreditRuleImpl.class);

    /**
     * CmCreditRule服务对象
     */
    @Autowired
    private ICmCreditRuleService<CmCreditRuleEntity> cmCreditRuleService;

    /**
     * CmCreditRule列表查询
     *
     * @param request
     *            CmCreditRule列表查询请求
     * @return CmCreditRule列表查询响应
     */
    @Override
    public CmCreditRuleListResponse getCmCreditRuleList(CmCreditRuleListRequest request) {
        CmCreditRuleListResponse response = new CmCreditRuleListResponse();
        try {
            QueryParams<CmCreditRuleEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmCreditRuleEntity> cmCreditRules = cmCreditRuleService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmCreditRules);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmCreditRule
     *
     * @param request
     *            CmCreditRule请求
     * @return 保存CmCreditRule响应
     */
    @Override
    public CmCreditRuleResponse addCmCreditRule(CmCreditRuleRequest request) {
        CmCreditRuleResponse response = new CmCreditRuleResponse();
        try {
            CmCreditRuleEntity entity = request.getEntity();
            cmCreditRuleService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmCreditRule通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除CmCreditRule响应
     */
    @Override
    public CmCreditRuleResponse deleteCmCreditRuleById(Integer id) {
        CmCreditRuleResponse response = new CmCreditRuleResponse();
        try {
            cmCreditRuleService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmCreditRule
     *
     * @param request
     *            修改CmCreditRule请求
     * @return 修改CmCreditRule响应
     */
    @Override
    public CmCreditRuleResponse updateCmCreditRule(CmCreditRuleRequest request) {
        CmCreditRuleResponse response = new CmCreditRuleResponse();
        try {
            cmCreditRuleService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmCreditRule
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取CmCreditRule响应
     */
    @Override
    public CmCreditRuleResponse getCmCreditRuleById(Integer id) {
        CmCreditRuleResponse response = new CmCreditRuleResponse();
        try {
            CmCreditRuleEntity entity = cmCreditRuleService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
