/**
 * Description: 只包含楼盘和经纪人评论删除后的扣分WS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:10
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmCreditRemoveRecordEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmCreditRemoveRecordListRequest;
import com.house365.ws.beans.request.CmCreditRemoveRecordRequest;
import com.house365.ws.beans.response.CmCreditRemoveRecordListResponse;
import com.house365.ws.beans.response.CmCreditRemoveRecordResponse;
import com.house365.ws.interfaces.server.ICmCreditRemoveRecord;
import com.house365.ws.service.interfaces.ICmCreditRemoveRecordService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 只包含楼盘和经纪人评论删除后的扣分WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmCreditRemoveRecord")
public class CmCreditRemoveRecordImpl implements ICmCreditRemoveRecord {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory
            .getLogger(CmCreditRemoveRecordImpl.class);

    /**
     * 只包含楼盘和经纪人评论删除后的扣分服务对象
     */
    @Autowired
    private ICmCreditRemoveRecordService<CmCreditRemoveRecordEntity> cmCreditRemoveRecordService;

    /**
     * 只包含楼盘和经纪人评论删除后的扣分列表查询
     *
     * @param request
     *            只包含楼盘和经纪人评论删除后的扣分列表查询请求
     * @return 只包含楼盘和经纪人评论删除后的扣分列表查询响应
     */
    @Override
    public CmCreditRemoveRecordListResponse getCmCreditRemoveRecordList(CmCreditRemoveRecordListRequest request) {
        CmCreditRemoveRecordListResponse response = new CmCreditRemoveRecordListResponse();
        try {
            QueryParams<CmCreditRemoveRecordEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmCreditRemoveRecordEntity> cmCreditRemoveRecords = cmCreditRemoveRecordService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmCreditRemoveRecords);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存只包含楼盘和经纪人评论删除后的扣分
     *
     * @param request
     *            只包含楼盘和经纪人评论删除后的扣分请求
     * @return 保存只包含楼盘和经纪人评论删除后的扣分响应
     */
    @Override
    public CmCreditRemoveRecordResponse addCmCreditRemoveRecord(CmCreditRemoveRecordRequest request) {
        CmCreditRemoveRecordResponse response = new CmCreditRemoveRecordResponse();
        try {
            CmCreditRemoveRecordEntity entity = request.getEntity();
            cmCreditRemoveRecordService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除只包含楼盘和经纪人评论删除后的扣分通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除只包含楼盘和经纪人评论删除后的扣分响应
     */
    @Override
    public CmCreditRemoveRecordResponse deleteCmCreditRemoveRecordById(Integer id) {
        CmCreditRemoveRecordResponse response = new CmCreditRemoveRecordResponse();
        try {
            cmCreditRemoveRecordService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改只包含楼盘和经纪人评论删除后的扣分
     *
     * @param request
     *            修改只包含楼盘和经纪人评论删除后的扣分请求
     * @return 修改只包含楼盘和经纪人评论删除后的扣分响应
     */
    @Override
    public CmCreditRemoveRecordResponse updateCmCreditRemoveRecord(CmCreditRemoveRecordRequest request) {
        CmCreditRemoveRecordResponse response = new CmCreditRemoveRecordResponse();
        try {
            cmCreditRemoveRecordService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取只包含楼盘和经纪人评论删除后的扣分
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取只包含楼盘和经纪人评论删除后的扣分响应
     */
    @Override
    public CmCreditRemoveRecordResponse getCmCreditRemoveRecordById(Integer id) {
        CmCreditRemoveRecordResponse response = new CmCreditRemoveRecordResponse();
        try {
            CmCreditRemoveRecordEntity entity = cmCreditRemoveRecordService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
