/**
 * Description: CmBrokerLabelWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:07
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmBrokerLabelEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmBrokerLabelListRequest;
import com.house365.ws.beans.request.CmBrokerLabelRequest;
import com.house365.ws.beans.response.CmBrokerLabelListResponse;
import com.house365.ws.beans.response.CmBrokerLabelResponse;
import com.house365.ws.interfaces.server.ICmBrokerLabel;
import com.house365.ws.service.interfaces.ICmBrokerLabelService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmBrokerLabelWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmBrokerLabel")
public class CmBrokerLabelImpl implements ICmBrokerLabel {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmBrokerLabelImpl.class);

    /**
     * CmBrokerLabel服务对象
     */
    @Autowired
    private ICmBrokerLabelService<CmBrokerLabelEntity> cmBrokerLabelService;

    /**
     * CmBrokerLabel列表查询
     *
     * @param request CmBrokerLabel列表查询请求
     * @return CmBrokerLabel列表查询响应
     */
    @Override
    public CmBrokerLabelListResponse getCmBrokerLabelList(CmBrokerLabelListRequest request) {
        CmBrokerLabelListResponse response = new CmBrokerLabelListResponse();
        try {
            QueryParams<CmBrokerLabelEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmBrokerLabelEntity> cmBrokerLabels = cmBrokerLabelService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmBrokerLabels);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmBrokerLabel
     *
     * @param request CmBrokerLabel请求
     * @return 保存CmBrokerLabel响应
     */
    @Override
    public CmBrokerLabelResponse addCmBrokerLabel(CmBrokerLabelRequest request) {
        CmBrokerLabelResponse response = new CmBrokerLabelResponse();
        try {
            CmBrokerLabelEntity entity = request.getEntity();
            cmBrokerLabelService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmBrokerLabel通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmBrokerLabel响应
     */
    @Override
    public CmBrokerLabelResponse deleteCmBrokerLabelById(Integer id) {
        CmBrokerLabelResponse response = new CmBrokerLabelResponse();
        try {
            cmBrokerLabelService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmBrokerLabel
     *
     * @param request 修改CmBrokerLabel请求
     * @return 修改CmBrokerLabel响应
     */
    @Override
    public CmBrokerLabelResponse updateCmBrokerLabel(CmBrokerLabelRequest request) {
        CmBrokerLabelResponse response = new CmBrokerLabelResponse();
        try {
            cmBrokerLabelService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmBrokerLabel
     *
     * @param id 唯一标识
     * @return 通过ID获取CmBrokerLabel响应
     */
    @Override
    public CmBrokerLabelResponse getCmBrokerLabelById(Integer id) {
        CmBrokerLabelResponse response = new CmBrokerLabelResponse();
        try {
            CmBrokerLabelEntity entity = cmBrokerLabelService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
