/**
 * Description: CmBrokerWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 18:47:32
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmBrokerEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmBrokerListRequest;
import com.house365.ws.beans.request.CmBrokerRequest;
import com.house365.ws.beans.response.CmBrokerListResponse;
import com.house365.ws.beans.response.CmBrokerResponse;
import com.house365.ws.interfaces.server.ICmBroker;
import com.house365.ws.service.interfaces.ICmBrokerService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmBrokerWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
@Service("cmBroker")
public class CmBrokerImpl implements ICmBroker {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmBrokerImpl.class);

    /**
     * CmBroker服务对象
     */
    @Autowired
    private ICmBrokerService<CmBrokerEntity> cmBrokerService;

    /**
     * CmBroker列表查询
     *
     * @param request CmBroker列表查询请求
     * @return CmBroker列表查询响应
     */
    @Override
    public CmBrokerListResponse getCmBrokerList(CmBrokerListRequest request) {
        CmBrokerListResponse response = new CmBrokerListResponse();
        try {
            QueryParams<CmBrokerEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<CmBrokerEntity> cmBrokers = cmBrokerService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmBrokers);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmBroker
     *
     * @param request CmBroker请求
     * @return 保存CmBroker响应
     */
    @Override
    public CmBrokerResponse addCmBroker(CmBrokerRequest request) {
        CmBrokerResponse response = new CmBrokerResponse();
        try {
            CmBrokerEntity entity = request.getEntity();
            cmBrokerService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmBroker通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmBroker响应
     */
    @Override
    public CmBrokerResponse deleteCmBrokerById(Integer id) {
        CmBrokerResponse response = new CmBrokerResponse();
        try {
            cmBrokerService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmBroker
     *
     * @param request 修改CmBroker请求
     * @return 修改CmBroker响应
     */
    @Override
    public CmBrokerResponse updateCmBroker(CmBrokerRequest request) {
        CmBrokerResponse response = new CmBrokerResponse();
        try {
            cmBrokerService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmBroker
     *
     * @param id 唯一标识
     * @return 通过ID获取CmBroker响应
     */
    @Override
    public CmBrokerResponse getCmBrokerById(Integer id) {
        CmBrokerResponse response = new CmBrokerResponse();
        try {
            CmBrokerEntity entity = cmBrokerService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
