/**
 * Description: CmAssessWS接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-12-29 上午 11:12:24
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-12-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CmAssessEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CmAssessListRequest;
import com.house365.ws.beans.request.CmAssessRequest;
import com.house365.ws.beans.response.CmAssessListResponse;
import com.house365.ws.beans.response.CmAssessResponse;
import com.house365.ws.interfaces.server.ICmAssess;
import com.house365.ws.service.interfaces.ICmAssessService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * CmAssessWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-12-29
 * @see
 * @since 1.0
 */
@Service("cmAssess")
public class CmAssessImpl implements ICmAssess {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CmAssessImpl.class);

    /**
     * CmAssess服务对象
     */
    @Autowired
    private ICmAssessService<CmAssessEntity> cmAssessService;

    /**
     * CmAssess列表查询
     *
     * @param request CmAssess列表查询请求
     * @return CmAssess列表查询响应
     */
    @Override
    public CmAssessListResponse getCmAssessList(CmAssessListRequest request) {
        CmAssessListResponse response = new CmAssessListResponse();
        try {
            QueryParams<CmAssessEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CmAssessEntity> cmAssesss = cmAssessService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmAssesss);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存CmAssess
     *
     * @param request CmAssess请求
     * @return 保存CmAssess响应
     */
    @Override
    public CmAssessResponse addCmAssess(CmAssessRequest request) {
        CmAssessResponse response = new CmAssessResponse();
        try {
            CmAssessEntity entity = request.getEntity();
            cmAssessService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除CmAssess通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CmAssess响应
     */
    @Override
    public CmAssessResponse deleteCmAssessById(Integer id) {
        CmAssessResponse response = new CmAssessResponse();
        try {
            cmAssessService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改CmAssess
     *
     * @param request 修改CmAssess请求
     * @return 修改CmAssess响应
     */
    @Override
    public CmAssessResponse updateCmAssess(CmAssessRequest request) {
        CmAssessResponse response = new CmAssessResponse();
        try {
            cmAssessService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取CmAssess
     *
     * @param id 唯一标识
     * @return 通过ID获取CmAssess响应
     */
    @Override
    public CmAssessResponse getCmAssessById(Integer id) {
        CmAssessResponse response = new CmAssessResponse();
        try {
            CmAssessEntity entity = cmAssessService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 每人保留50条记录
     */
    @Override
    public void cleanRecordsJob() {
        LOGGER.info("RUNNING JOB cleanRecordsJob");
        //get userId list which has record gt 100
        List<String> userIds = cmAssessService.getClearIds();
        if (userIds != null && !userIds.isEmpty()) {
            for (String userId : userIds) {
                Integer id = cmAssessService.getMinIdByUserId(userId);
                cmAssessService.removeWaste(userId, id);
            }
        }

    }

    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
