/**
 * Description: CmUser数据访问接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2015-08-10 下午 17:06:21
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.entity.CmUserEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;

import java.util.List;
import java.util.Map;

/**
 * CmUser数据访问接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-10
 * @see
 * @since 1.0
 */
public interface ICmUserDao<T extends CmUserEntity> extends Dao<T> {
    List<CmUserEntity> getPhoneMissList(QueryParams<?> queryParams);

    /**
     * 通过app端传来的用户ID外键获取用户信息
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @param userId
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年8月20日]
     * @since [产品/模块版本](可选)
     */
    CmUserEntity getUserByUserId(Integer userId, String cityKey, Integer useridType);

    /**
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @param
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年11月6日]
     * @since [产品/模块版本](可选)
     */
    Integer countAllCreditsNotNull();

    Integer countDeviceInvite(String deviceId);

    /**
     * 查询所有积分余额
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @return
     * @author yinchangming
     * @version [v1.0.0, 2015年11月6日]
     * @since [产品/模块版本](可选)
     */
    Integer countAllRemainingCredits();


    /**
     * 修改会员积分
     *
     * @param userId  会员ID
     * @param credits 积分值
     */
    void updateCredits(int userId, int credits);

    Map getUserCreditTask(String userId);

    CmUserEntity getUserEntity(String phone);

    /**
     * 查询事业部榜单
     *
     * @param startTime
     * @param endTime
     * @return
     */
    List<CmUserEntity> selectRanksByDivision(final String startTime, final String endTime);

    /**
     * 查询个人榜单
     *
     * @param startTime
     * @param endTime
     * @return
     */
    List<CmUserEntity> selectRanksByInvite(final String startTime, final String endTime);

    /**
     * 查询个人推荐信息
     *
     * @param startTime
     * @param endTime
     * @return
     */
    CmUserEntity getRankByInvite(final Integer userId, final String startTime, final String endTime);
}
