/**
 * Description: CmCreditRecord数据访问接口
 * Copyright:   Copyright (c)2015
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2015-08-14 上午 09:30:51
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2015-08-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.entity.CmCreditRecordEntity;
import com.house365.beans.entity.CmCreditRuleEntity;
import com.house365.beans.entity.CmUserEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;

import java.util.List;

/**
 * CmCreditRecord数据访问接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2015-08-14
 * @see
 * @since 1.0
 */
public interface ICmCreditRecordDao<T extends CmCreditRecordEntity> extends Dao<T>{

    CmCreditRecordEntity saveQuestion(CmUserEntity user, String questionId) throws Exception;

    /**
     * 保存商品兑换记录
     * 功能描述: <br>
     * 〈功能详细描述〉
     *
     * @author yinchangming
     * @version [v1.0.0, 2015年8月21日]
     * @param user
     * @param orderId
     * @param goodsCount
     * @param goodsId
     * @since [产品/模块版本](可选)
     */
    CmCreditRecordEntity saveGoodsExchangeRecord(CmUserEntity user, int orderId, int goodsCount, int goodsId) throws Exception;

    CmCreditRecordEntity saveBrokerCommentRemoveRecord(CmUserEntity user, int commentId) throws Exception;

    CmCreditRecordEntity saveHouseCommentRemoveRecord(CmUserEntity user, int commentId) throws Exception;

    CmCreditRecordEntity saveHouseResourceRecord(CmUserEntity user, int hosueId) throws Exception;

    boolean checkByRule(CmCreditRuleEntity rule, int userId);

    CmCreditRecordEntity saveChangeCreditsRecord(CmUserEntity user,Integer rule, Integer credits) throws Exception;

    CmCreditRecordEntity saveSignCreditsRecord(CmUserEntity user, Integer credits) throws Exception;
    
    CmCreditRecordEntity saveSignLotteryCreditsRecord(CmUserEntity user, int credits) throws Exception;

    CmCreditRecordEntity saveLotteryCreditsRecord(CmUserEntity user, int credits) throws Exception;

    //业主社区发帖回帖
    CmCreditRecordEntity saveBBSRecord(CmUserEntity user) throws Exception;

    CmCreditRecordEntity saveRecord(CmUserEntity user, Integer ruleId, Integer credit) throws Exception;

    //房博士提问扣积分
    CmCreditRecordEntity saveQuestionMinusRecord(CmUserEntity user, Integer credit) throws Exception;

    CmCreditRecordEntity saveHouseCommentRecord(CmUserEntity user, int commentId) throws Exception;

    CmCreditRecordEntity saveBrokerCommentRecord(CmUserEntity user, int commentId) throws Exception;
    
    CmCreditRecordEntity saveInviteRecord(CmUserEntity user, int recordId) throws Exception;
    
    CmCreditRecordEntity saveRegisterRecord(CmUserEntity user) throws Exception;
    
    CmCreditRecordEntity saveUploadPhotoRecord(CmUserEntity user) throws Exception;
    
    Integer removeCredit(Integer commentId,Integer ruleId);

    CmCreditRecordEntity saveAddExcellentRecord(CmUserEntity user, int recordId) throws Exception;

    /**
     * 获取条件内积分总和
     * 
     */
    Integer getTotalCreditsByCondition(QueryParams<CmCreditRecordEntity> queryParams);

    List<CmCreditRecordEntity> queryByPageNew(QueryParams<?> queryParams);

    Integer getUserInviteCount(QueryParams<CmCreditRecordEntity> params);

    /**
     *  获取条件内用户数（不重复）
     * 
     */
    Integer getDistinctUserCount(QueryParams<CmCreditRecordEntity> queryParams);


    List<CmCreditRecordEntity> statisticsByPage(QueryParams<?> queryParams);

    Integer statisticsByPageCount(QueryParams<CmCreditRecordEntity> queryParams);
}
