/**
 * Description: 商品促销关联数据访问实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-01 上午 10:52:46
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-01   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.google.common.base.Joiner;
import org.springframework.stereotype.Repository;
import com.house365.dao.system.impl.DefaultDaoImpl;

import com.house365.ws.dao.interfaces.ICmPromotionProductDao;
import com.house365.beans.entity.CmPromotionProductEntity;

import java.util.HashMap;
import java.util.List;

/**
 * 商品促销关联数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-01
 * @see
 * @since 1.0
 */
@Repository("cmPromotionProductDao")
public class CmPromotionProductDaoImpl extends DefaultDaoImpl<CmPromotionProductEntity> implements ICmPromotionProductDao<CmPromotionProductEntity> {

    @Override
    public void updateStatus(List<String> productIds, final int status) {
        final String productId = Joiner.on(",").join(productIds);
        getReadTemplate().update(getStatement(), new HashMap<String, String>() {
            private static final long serialVersionUID = 1L;
            {
                put("productId", productId);
                put("status", String.valueOf(status));
            }
        });
    }
}
